<?php

namespace FiloBlu\Newsletter\Block\LandingPage;

use FiloBlu\Newsletter\Helper\Data;
use Magento\Customer\Block\Form\Register;
use Magento\Customer\Model\Session;
use Magento\Customer\Model\Url;
use Magento\Directory\Model\ResourceModel\Country\CollectionFactory;
use Magento\Framework\App\Cache\Type\Config;
use Magento\Framework\Json\EncoderInterface;
use Magento\Framework\Module\Manager;
use Magento\Framework\Registry;
use Magento\Framework\View\Element\Template\Context;

/**
 * Class FormRegister
 * @package FiloBlu\Newsletter\Block\LandingPage
 */
class FormRegister extends Register
{

    /**
     * Helper
     *
     * @var Data
     */
    public $_helper;

    /**
     * @var Registry
     */
    protected $_coreRegistry;

    /**
     * FormRegister constructor.
     * @param Context $context
     * @param \Magento\Directory\Helper\Data $directoryHelper
     * @param EncoderInterface $jsonEncoder
     * @param Config $configCacheType
     * @param \Magento\Directory\Model\ResourceModel\Region\CollectionFactory $regionCollectionFactory
     * @param CollectionFactory $countryCollectionFactory
     * @param Manager $moduleManager
     * @param Session $customerSession
     * @param Url $customerUrl
     * @param Data $helper
     * @param Registry $registry
     * @param array $data
     */
    public function __construct(
        Context $context,
        \Magento\Directory\Helper\Data $directoryHelper,
        EncoderInterface $jsonEncoder,
        Config $configCacheType,
        \Magento\Directory\Model\ResourceModel\Region\CollectionFactory $regionCollectionFactory,
        CollectionFactory $countryCollectionFactory,
        Manager $moduleManager,
        Session $customerSession,
        Url $customerUrl,
        Data $helper,
        Registry $registry,
        array $data = []
    )
    {
        parent::__construct(
            $context,
            $directoryHelper,
            $jsonEncoder,
            $configCacheType,
            $regionCollectionFactory,
            $countryCollectionFactory,
            $moduleManager,
            $customerSession,
            $customerUrl,
            $data
        );

        $this->_helper = $helper;
        $this->_coreRegistry = $registry;
    }

    /**
     * Retrieve form action url and set "secure" param to avoid confirm
     * message when we submit form from secure page to unsecure
     *
     * @return string
     */
    public function getFormActionUrl()
    {
        return $this->getUrl('newsletterajax/subscriber/newlandingregisteraction', ['_secure' => true]);
    }

    protected function _toHtml()
    {

        if (!$this->_helper->getConfig('general/enabled') || $this->getLandingPage()['form_type'] != 1) {
            return '';
        }

        return parent::_toHtml();
    }

    public function getLandingPage()
    {
        if (!$this->getLandingPageEntity()) {
            $this->setLandingPageEntity($this->_coreRegistry->registry('newsletter_landingpage_entity'));
        }

        return $this->getLandingPageEntity()->getData();
    }

}
