<?php

namespace FiloBlu\Newsletter\Block\Adminhtml\LandingPage\Grid\Renderer;

use FiloBlu\Newsletter\Helper\Data;
use FiloBlu\Newsletter\Model\LandingPage;
use Magento\Backend\Block\Context;
use Magento\Backend\Block\Widget\Grid\Column\Renderer\AbstractRenderer as AbstractRenderer;
use Magento\Framework\DataObject;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Store\Model\StoreManagerInterface;

class EditLink extends AbstractRenderer
{
    /**
     * @var StoreManagerInterface
     */
    protected $_storeManager;
    /**
     * @var Data
     */
    protected $_helper;
    protected $_modelLanding;

    /**
     * @param Context $context
     * @param StoreManagerInterface $storeManager
     * @param Data $helper
     * @param LandingPage $modelLanding
     * @param array $data
     */
    public function __construct(
        Context $context,
        StoreManagerInterface $storeManager,
        Data $helper,
        LandingPage $modelLanding,
        array $data = []
    )
    {
        $this->_storeManager = $storeManager;
        $this->_helper = $helper;
        $this->_modelLanding = $modelLanding;
        parent::__construct($context, $data);
        $this->_authorization = $context->getAuthorization();
    }

    /**
     * Renders grid column
     *
     * @param DataObject $row
     * @return string
     * @throws NoSuchEntityException
     */
    public function render(DataObject $row)
    {

        if ($this->_helper->getConfig('general/newsletter_edit_landing') != 0) {

            $storeId = $row->getStoreId();
            $storeUrl = $this->_storeManager->getStore($storeId)->getBaseUrl();
            $landingId = $this->_helper->getConfig('general/newsletter_edit_landing');
            $model = $this->_modelLanding->getLandingPageById($landingId);
            $landingUrlKey = $model->getUrlKey();
            /**
             * urlencode needed when email has a '+' inside,
             * which becomes a space in the getRequest
             * on FiloBlu\Newsletter\Controller\Index\LandingPage class
             * and the match in the DB fails.
             */
            $subscriberEmail = urlencode($row->getSubscriberEmail());
            $subscriberId = $row->getSubscriberId();
            $subscriberConfirmCode = $row->getSubscriberConfirmCode();

            return '<a href="'
                . $storeUrl
                . $landingUrlKey
                . '?email=' . $subscriberEmail
                . '&id=' . $subscriberId
                . '&confirm_code=' . $subscriberConfirmCode
                . '&store_id=' . $storeId
                . '&_=' . time()
                . '" target="_blank">Edit</a>';

        }

        return '';
    }
}