<?php

namespace FiloBlu\Newsletter\Block\Account\Newsletter;

use FiloBlu\Newsletter\Helper\Data;
use Magento\Customer\Model\Session;
use Magento\Framework\View\Element\Template;
use Magento\Framework\View\Element\Template\Context;

/**
 * Class AdditionalFields
 * @package FiloBlu\Newsletter\Block\Account\Newsletter
 */
class AdditionalFields extends Template
{

    /**
     * Helper
     *
     * @var Data
     */
    public $_helper;

    /**
     * @var Session
     */
    public $_customerSession;

    /**
     * AdditionalFields constructor.
     * @param Context $context
     * @param Data $helper
     * @param Session $customerSession
     * @param array $data
     */
    public function __construct(
        Context $context,
        Data $helper,
        Session $customerSession,
        array $data = []
    ) {
        $this->_helper = $helper;
        $this->_customerSession = $customerSession;
        parent::__construct($context, $data);
    }

    protected function _toHtml()
    {
        if (!$this->_helper->getConfig('general/enabled')) {
            return '';
        }

        return parent::_toHtml();
    }
}
