define([
    "jquery",
    "Magento_Ui/js/modal/modal",
    "Magento_Customer/js/customer-data",
    "jquery/ui",
    "mage/cookies",
    "mage/translate",
    "prototype"
], function ($, modal, customerData) {
    "use strict";

    //creating jquery widget
    $.widget('filoblu.newsletter_popup', {
        popup: {},
        _create: function () {

            var newsletterData = customerData.get('newsletter-config');

            newsletterData.subscribe(function (newsletterConfig) {
                if (!this.popup.created) {
                    this.createPopup(newsletterConfig.is_already_subscribed);
                }
            }, this);

            if (typeof newsletterData().is_already_subscribed === "undefined") {
                customerData.reload(['newsletter-config'], false);
            } else {
                this.createPopup(newsletterData().is_already_subscribed);
            }

        },
        createPopup: function (is_already_subscribed) {
            
            var that = this;

            this.popup.created = true;

            var options = this.options,
                    auto_open = true,
                    me = this,
                    optionsPopup = {},
                    popup;

            if (
                    is_already_subscribed ||
                    $.mage.cookies.get(options.cookie_name)
                    ) {
                auto_open = false;
            }

            optionsPopup = {
                type: 'popup',
                clickableOverlay: true,
                responsive: true,
                modalClass: 'newletterModal',
                footerFormId: '#newsletter-validate-detail',
                innerScroll: true,
                autoOpen: false,
                title: '',
                buttons: [],
                closed: function () {

                    if (!$.mage.cookies.get(options.cookie_name)) {
                        var toDay = new Date();//for getting todays date.
                        toDay.setTime(toDay.getTime());
                        var expaireTime = options.cookie_duration * 1000;
                        var expaireDate = new Date(toDay.getTime() + (expaireTime));

                        $.mage.cookies.set(options.cookie_name, 'subscribed', {"expires": expaireDate});
                    }
                }
            };
            
            
            popup = modal(optionsPopup, $(options.popup_id));
        
            $('#popup-newsletter').on('modalopened', function() { 
                that.popup.opened = true; 
              });

            if(auto_open){
                setTimeout(function () {
                    if (!that.popup.opened) {
                        $('#popup-newsletter').modal('openModal');
                    }
                }, parseInt(options.popup_timeout) || 0);
            }

            $(optionsPopup.footerFormId).submit(function (e) {
                e.preventDefault();

                if ($(optionsPopup.footerFormId).valid()) {
                    $('#popup-newsletter').modal('openModal');
                    if (!$('.newletterModal').hasClass('extended')) {
                        me.extendNewsletterModal();
                    }
                    $('#popup-newsletter input[name=email]').val($('#newsletter').val());
                }
            });


            $(options.submit_btn).on("click", function (e) {
                me.removeMsg($(options.messagesContainer), 'success-msg');
                me.removeMsg($(options.messagesContainer), 'error-msg');

                if (!$('.newletterModal').hasClass('extended')) {
                    e.preventDefault();
                    if ($(options.submit_form).valid()) {
                        me.extendNewsletterModal();
                    }
                    return false;
                }

                if ($(options.submit_form).valid() && (options.token_invisible_recaptcha ? grecaptcha.getResponse() : true)) {
                    me.toggleNewsletterLoader();

                    $.ajax({
                        showLoader: true,
                        url: $(options.submit_form).attr("action"),
                        data: $(options.submit_form).serialize(),
                        type: "POST",
                        dataType: 'json'
                    }).done(function (result) {

                        if (result) {
                            if (result.success) {

                                if (window.ga) {
                                    window.ga('send',
                                            {hitType: 'event', eventCategory: 'Newsletter', eventAction: 'click', eventLabel: 'Iscrizione newsletter'}
                                    );
                                }

                                window.dataLayer = window.dataLayer || [];
                                dataLayer.push({
                                    'event': 'newsletter',
                                    'newsletter': {
                                        'category': 'Newsletter',
                                        'action': 'click',
                                        'label': 'Iscrizione newsletter'
                                    }
                                });

								$('#newsletter-form').hide('slide',{direction: 'down'},250);
								$('#newsletter').val('');/* empty email inputs after submit success */
								$('#popup-newsletter').find('input[name=dob-newsletter-birthday]').val('');
								$('#popup-newsletter').find('input[name=dob-newsletter-value]').val('');
                                me.addMsg($(options.messagesContainer), result.message, 'success-msg');

                                setTimeout(function () {
									$(optionsPopup.footerFormId)[0].reset();
                                    popup.closeModal();
                                    document.getElementById('newsletter-form').reset();
                                    me.removeMsg($(options.messagesContainer), 'success-msg');
                                }, options.close_popup_millisec);

                                if(options.token_invisible_recaptcha){
                                    grecaptcha.reset();
                                }

                            } else {
                                me.addMsg($(options.messagesContainer), result.message, 'error-msg');
                            }

                        }

                        me.toggleNewsletterLoader();

                        if(options.token_invisible_recaptcha){
                            grecaptcha.reset();
                        }

                    });
                }
            });
        },
        addMsg: function (block, message, messageClass) {
            if (typeof (message) === 'object' && message.length > 0) {
                message.each(function (msg) {
                    this._appendMessage(block, msg, messageClass);
                }.bind(this));
            } else if (typeof (message) === 'string') {
                this._appendMessage(block, message, messageClass);
            }
        },
        _appendMessage: function (block, message, messageClass) {
            var currentMessage = null,
                    messageSection = block.find("." + messageClass + " ol"),
                    newMessage;

            if (messageSection.length === 0) {

                var messageElement = new Element('div');

                messageElement.addClassName(messageClass);
                messageElement.appendChild(new Element('ol'));

                block.append(messageElement);
                currentMessage = messageElement.down();
                newMessage = new Element('li');
                newMessage.update(message);
                currentMessage.appendChild(newMessage);
            } else {
                currentMessage = messageSection.first();
                newMessage = new Element('li');
                newMessage.update(message);
                currentMessage.append(newMessage);
            }

        },
        removeMsg: function (block, messageClass) {

            block.find('.' + messageClass).each(function (index, el) {
                el.remove();
            });
        },

        toggleNewsletterLoader: function () {
            $('#newsletter-loader').toggle();
        },

        extendNewsletterModal: function () {
            $('.newletterModal').animate({
                height: $(window).height()
            }, function () {
                $('.to-show', '#newsletter-form').slideDown();
                $('.newletterModal').addClass('extended');
            });
        }

    });

    return $.filoblu.newsletter_popup;
});
