<?php

namespace FiloBlu\Newsletter\Setup;

use Magento\Framework\Setup\UpgradeSchemaInterface;
use Magento\Framework\Setup\SchemaSetupInterface;
use Magento\Framework\Setup\ModuleContextInterface;

class UpgradeSchema implements UpgradeSchemaInterface {

    public function upgrade(SchemaSetupInterface $setup, ModuleContextInterface $context) {
        $setup->startSetup();

        if (version_compare($context->getVersion(), '1.0.1') < 0) {

            //code to upgrade to 1.0.1
            // Get module table
            $tableName = $setup->getTable('filoblu_newsletter_subscriber_info');

            // Check if the table already exists
            if ($setup->getConnection()->isTableExists($tableName) == true) {
                // Declare data
                $columns = [
                    'gender' => [
                        'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                        'length' => 255,
                        'nullable' => true,
                        'comment' => 'Gender'
                    ],
                ];

                $connection = $setup->getConnection();
                foreach ($columns as $name => $definition) {
                    $connection->addColumn($tableName, $name, $definition);
                }
            }
        }
        if (version_compare($context->getVersion(), '1.0.2') < 0) {

            //code to upgrade to 1.0.2
            // Get module table
            $tableName = $setup->getTable('filoblu_newsletter_subscriber_info');

            // Check if the table already exists
            if ($setup->getConnection()->isTableExists($tableName) == true) {
                // Declare data
                $columns = [
                    'collections' => [
                        'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                        'length' => 255,
                        'nullable' => true,
                        'comment' => 'Collections'
                    ],
                    'source' => [
                        'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                        'length' => 100,
                        'nullable' => true,
                        'comment' => 'Source'
                    ],
                ];

                $connection = $setup->getConnection();
                foreach ($columns as $name => $definition) {
                    $connection->addColumn($tableName, $name, $definition);
                }
            }
        }
        if (version_compare($context->getVersion(), '1.0.3') < 0) {

            //code to upgrade to 1.0.3
            // Get module table
            $tableName = $setup->getTable('filoblu_newsletter_subscriber_info');

            // Check if the table already exists
            if ($setup->getConnection()->isTableExists($tableName) == true) {
                // Declare data
                $columns = [
                    'language' => [
                        'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                        'length' => 10,
                        'nullable' => true,
                        'comment' => 'Language'
                    ],
                    'website_name' => [
                        'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                        'length' => 100,
                        'nullable' => true,
                        'comment' => 'Website Name'
                    ],
                ];

                $connection = $setup->getConnection();
                foreach ($columns as $name => $definition) {
                    $connection->addColumn($tableName, $name, $definition);
                }
            }
        }
        if (version_compare($context->getVersion(), '1.0.4') < 0) {

            //code to upgrade to 1.0.4
            // Get module table
            $tableName = $setup->getTable('filoblu_newsletter_subscriber_info');

            // Check if the table already exists
            if ($setup->getConnection()->isTableExists($tableName) == true) {
                // Declare data
                $columns = [
                    'birthday' => [
                        'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                        'length' => 5,
                        'nullable' => true,
                        'comment' => 'Birthday'
                    ]
                ];

                $connection = $setup->getConnection();
                foreach ($columns as $name => $definition) {
                    $connection->addColumn($tableName, $name, $definition);
                }
            }
        }

        if (version_compare($context->getVersion(), '1.0.6') < 0) {

            //code to upgrade to 1.0.6

            /**
             * Create table 'stores'
             */
            if (!$setup->tableExists('filoblu_newsletter_landing')) {
                $table = $setup->getConnection()->newTable(
                                $setup->getTable('filoblu_newsletter_landing'))
                        ->addColumn(
                                'landing_id', \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER, null, ['identity' => true, 'unsigned' => true, 'nullable' => false, 'primary' => true], 'Landing Id'
                        )->addColumn(
                                'enabled', \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER, null, ['nullable' => false, 'default' => '0'], 'Enabled'
                        )->addColumn(
                                'title', \Magento\Framework\DB\Ddl\Table::TYPE_TEXT, 255, ['nullable' => false], 'Title'
                        )->addColumn(
                                'description', \Magento\Framework\DB\Ddl\Table::TYPE_TEXT, 255, ['nullable' => true], 'Description'
                        )->addColumn(
                                'image', \Magento\Framework\DB\Ddl\Table::TYPE_TEXT, 255, [], 'Image'
                        )->addColumn(
                                'url_key', \Magento\Framework\DB\Ddl\Table::TYPE_TEXT, 100, ['nullable' => false], 'Url Key'
                        )->addColumn(
                                'thankyou_id', \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER, null, ['nullable' => false], 'Thank You Id'
                        )->addColumn(
                                'preconfirm_id', \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER, null, ['nullable' => false], 'Pre Confirm Id'
                        )
                        ->setComment(
                        'landing page'
                );
                $setup->getConnection()->createTable($table);
            }
        }

        if (version_compare($context->getVersion(), '1.0.7') < 0) {

            //code to upgrade to 1.0.7
            // Get module table
            $tableName = $setup->getTable('filoblu_newsletter_landing');

            // Check if the table already exists
            if ($setup->getConnection()->isTableExists($tableName) == true) {
                // Declare data
                $columns = [
                    'store_ids' => [
                        'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                        'nullable' => false,
                        'comment' => 'Store ids'
                    ],
                ];

                $connection = $setup->getConnection();
                foreach ($columns as $name => $definition) {
                    $connection->addColumn($tableName, $name, $definition);
                }
            }
        }

        if (version_compare($context->getVersion(), '1.0.8') < 0) {

            //code to upgrade to 1.0.8
            // add fulltext index to permitt fulltext search in grid
            if ($setup->tableExists('filoblu_newsletter_landing')) {
                $setup->getConnection()->addIndex(
                        'filoblu_newsletter_landing', //table name
                        'title', // index name
                        [
                    'title'   // filed or column name
                        ], \Magento\Framework\DB\Adapter\AdapterInterface::INDEX_TYPE_FULLTEXT //type of index
                );
            }
        }

        if (version_compare($context->getVersion(), '1.0.9') < 0) {

            //code to upgrade to 1.0.9

            if (!$setup->tableExists('filoblu_newsletter_preconfirm')) {
                $table = $setup->getConnection()->newTable(
                                $setup->getTable('filoblu_newsletter_preconfirm'))
                        ->addColumn(
                                'preconfirm_id', \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER, null, ['identity' => true, 'unsigned' => true, 'nullable' => false, 'primary' => true], 'Landing Id'
                        )->addColumn(
                                'enabled', \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER, null, ['nullable' => false, 'default' => '0'], 'Enabled'
                        )->addColumn(
                                'title', \Magento\Framework\DB\Ddl\Table::TYPE_TEXT, 255, ['nullable' => false], 'Title'
                        )->addColumn(
                                'description', \Magento\Framework\DB\Ddl\Table::TYPE_TEXT, 255, ['nullable' => true], 'Description'
                        )->addColumn(
                                'image', \Magento\Framework\DB\Ddl\Table::TYPE_TEXT, 255, [], 'Image'
                        )->addColumn(
                                'url_key', \Magento\Framework\DB\Ddl\Table::TYPE_TEXT, 100, ['nullable' => false], 'Url Key'
                        )
                        ->setComment(
                        'preconfirm page'
                );
                $setup->getConnection()->createTable($table);
            }

            if (!$setup->tableExists('filoblu_newsletter_thankyou')) {
                $table = $setup->getConnection()->newTable(
                                $setup->getTable('filoblu_newsletter_thankyou'))
                        ->addColumn(
                                'thankyou_id', \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER, null, ['identity' => true, 'unsigned' => true, 'nullable' => false, 'primary' => true], 'Landing Id'
                        )->addColumn(
                                'enabled'
                                , \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER
                                , null
                                , ['nullable' => false, 'default' => '0']
                                , 'Enabled'
                        )->addColumn(
                                'title', \Magento\Framework\DB\Ddl\Table::TYPE_TEXT, 255, ['nullable' => false], 'Title'
                        )->addColumn(
                                'description', \Magento\Framework\DB\Ddl\Table::TYPE_TEXT, 255, ['nullable' => true], 'Description'
                        )->addColumn(
                                'image', \Magento\Framework\DB\Ddl\Table::TYPE_TEXT, 255, [], 'Image'
                        )->addColumn(
                                'url_key', \Magento\Framework\DB\Ddl\Table::TYPE_TEXT, 100, ['nullable' => false], 'Url Key'
                        )
                        ->setComment(
                        'thankyou page'
                );
                $setup->getConnection()->createTable($table);
            }
        }

        if (version_compare($context->getVersion(), '1.0.10') < 0) {

            //code to upgrade to 1.0.10
            // add fulltext index to permitt fulltext search in grid
            if ($setup->tableExists('filoblu_newsletter_preconfirm')) {
                $setup->getConnection()->addIndex(
                        'filoblu_newsletter_preconfirm', //table name
                        'title', // index name
                        [
                    'title'   // filed or column name
                        ], \Magento\Framework\DB\Adapter\AdapterInterface::INDEX_TYPE_FULLTEXT //type of index
                );
            }

            if ($setup->tableExists('filoblu_newsletter_thankyou')) {
                $setup->getConnection()->addIndex(
                        'filoblu_newsletter_thankyou', //table name
                        'title', // index name
                        [
                    'title'   // filed or column name
                        ], \Magento\Framework\DB\Adapter\AdapterInterface::INDEX_TYPE_FULLTEXT //type of index
                );
            }
        }

        if (version_compare($context->getVersion(), '1.0.11') < 0) {

            //code to upgrade to 1.0.11
            // Get module table
            $tableNamePreconfirm = $setup->getTable('filoblu_newsletter_preconfirm');

            // Check if the table already exists
            if ($setup->getConnection()->isTableExists($tableNamePreconfirm) == true) {
                // Declare data
                $columns = [
                    'store_ids' => [
                        'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                        'nullable' => false,
                        'comment' => 'Store ids'
                    ],
                ];

                $connection = $setup->getConnection();
                foreach ($columns as $name => $definition) {
                    $connection->addColumn($tableNamePreconfirm, $name, $definition);
                }
            }

            $tableNameThankYou = $setup->getTable('filoblu_newsletter_thankyou');

            // Check if the table already exists
            if ($setup->getConnection()->isTableExists($tableNameThankYou) == true) {
                // Declare data
                $columns = [
                    'store_ids' => [
                        'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                        'nullable' => false,
                        'comment' => 'Store ids'
                    ],
                ];

                $connection = $setup->getConnection();
                foreach ($columns as $name => $definition) {
                    $connection->addColumn($tableNameThankYou, $name, $definition);
                }
            }
        }

        if (version_compare($context->getVersion(), '1.0.12') < 0) {

            //code to upgrade to 1.0.12
            // Get module table
            $tableName = $setup->getTable('filoblu_newsletter_landing');

            // Check if the table already exists
            if ($setup->getConnection()->isTableExists($tableName) == true) {
                // Declare data
                $columns = [
                    'code' => [
                        'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                        'length' => 50,
                        'nullable' => false,
                        'comment' => 'Code'
                    ],
                    'custom_js' => [
                        'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                        'length' => 255,
                        'nullable' => false,
                        'comment' => 'Custom Js'
                    ]
                ];

                $connection = $setup->getConnection();
                foreach ($columns as $name => $definition) {
                    $connection->addColumn($tableName, $name, $definition);
                }
            }

            $tableName = $setup->getTable('filoblu_newsletter_preconfirm');

            // Check if the table already exists
            if ($setup->getConnection()->isTableExists($tableName) == true) {
                // Declare data
                $columns = [
                    'custom_js' => [
                        'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                        'length' => 255,
                        'nullable' => false,
                        'comment' => 'Custom Js'
                    ]
                ];

                $connection = $setup->getConnection();
                foreach ($columns as $name => $definition) {
                    $connection->addColumn($tableName, $name, $definition);
                }
            }

            $tableName = $setup->getTable('filoblu_newsletter_thankyou');

            // Check if the table already exists
            if ($setup->getConnection()->isTableExists($tableName) == true) {
                // Declare data
                $columns = [
                    'custom_js' => [
                        'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                        'length' => 255,
                        'nullable' => false,
                        'comment' => 'Custom Js'
                    ]
                ];

                $connection = $setup->getConnection();
                foreach ($columns as $name => $definition) {
                    $connection->addColumn($tableName, $name, $definition);
                }
            }
        }
        if (version_compare($context->getVersion(), '1.0.13') < 0) {

            //code to upgrade to 1.0.13

            $tableName = $setup->getTable('filoblu_newsletter_preconfirm');

            // Check if the table already exists
            if ($setup->getConnection()->isTableExists($tableName) == true) {
                // Declare data
                $columns = [
                    'require_cookie' => [
                        'type' => \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
                        'nullable' => false,
                        'default' => '0',
                        'comment' => 'Require Cookie'
                    ]
                ];


                $connection = $setup->getConnection();
                foreach ($columns as $name => $definition) {
                    $connection->addColumn($tableName, $name, $definition);
                }
            }

            $tableName = $setup->getTable('filoblu_newsletter_thankyou');

            // Check if the table already exists
            if ($setup->getConnection()->isTableExists($tableName) == true) {
                // Declare data
                $columns = [
                    'require_cookie' => [
                        'type' => \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
                        'nullable' => false,
                        'default' => '0',
                        'comment' => 'Require Cookie'
                    ]
                ];

                $connection = $setup->getConnection();
                foreach ($columns as $name => $definition) {
                    $connection->addColumn($tableName, $name, $definition);
                }
            }
        }
        if (version_compare($context->getVersion(), '1.0.14') < 0) {

            //code to upgrade to 1.0.14

            $tableName = $setup->getTable('filoblu_newsletter_preconfirm');

            // Check if the table already exists
            if ($setup->getConnection()->isTableExists($tableName) == true) {
                $setup->getConnection()->changeColumn(
                        $tableName, 'description', 'description', [
                    'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                    'comment' => 'Description'
                        ]
                );
                $setup->getConnection()->changeColumn(
                        $tableName, 'custom_js', 'custom_js', [
                    'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                    'comment' => 'Custom Js'
                        ]
                );
            }
            $tableName = $setup->getTable('filoblu_newsletter_thankyou');

            // Check if the table already exists
            if ($setup->getConnection()->isTableExists($tableName) == true) {
                $setup->getConnection()->changeColumn(
                        $tableName, 'description', 'description', [
                    'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                    'comment' => 'Description'
                        ]
                );
                $setup->getConnection()->changeColumn(
                        $tableName, 'custom_js', 'custom_js', [
                    'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                    'comment' => 'Custom Js'
                        ]
                );
            }
            $tableName = $setup->getTable('filoblu_newsletter_landing');

            // Check if the table already exists
            if ($setup->getConnection()->isTableExists($tableName) == true) {
                $setup->getConnection()->changeColumn(
                        $tableName, 'description', 'description', [
                    'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                    'comment' => 'Description'
                        ]
                );
                $setup->getConnection()->changeColumn(
                        $tableName, 'custom_js', 'custom_js', [
                    'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                    'comment' => 'Custom Js'
                        ]
                );
            }
            $tableName = $setup->getTable('filoblu_newsletter_subscriber_info');

            // Check if the table already exists
            if ($setup->getConnection()->isTableExists($tableName) == true) {
                $setup->getConnection()->changeColumn(
                        $tableName, 'collections', 'collections', [
                    'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                    'comment' => 'Collections'
                        ]
                );
            }
        }

        if (version_compare($context->getVersion(), '1.0.15') < 0) {

            //code to upgrade to 1.0.15

            $tableName = $setup->getTable('filoblu_newsletter_subscriber_info');

            // Check if the table already exists
            if ($setup->getConnection()->isTableExists($tableName) == true) {
                $setup->getConnection()->changeColumn(
                        $tableName, 'dob', 'dob', [
                    'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                    'comment' => 'Date Of Birth'
                        ]
                );
            }
        }

        if (version_compare($context->getVersion(), '1.0.17') < 0) {

            //code to upgrade to 1.0.17

            $tableName = $setup->getTable('filoblu_newsletter_landing');
            /**
             * Create field for registration
             */
            if ($setup->tableExists('filoblu_newsletter_landing')) {

                // Declare data
                $columns = [
                    'form_type' => [
                        'type' => \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
                        'nullable' => false,
                        'default' => '0',
                        'comment' => 'Form Type'
                    ]
                ];

                $connection = $setup->getConnection();
                foreach ($columns as $name => $definition) {
                    $connection->addColumn($tableName, $name, $definition);
                }
            }
        }
        
        if (version_compare($context->getVersion(), '1.0.18') < 0) {

            //code to upgrade to 1.0.18
            // Get module table

            $tableName = $setup->getTable('filoblu_newsletter_subscriber_info');

            // Check if the table already exists
            if ($setup->getConnection()->isTableExists($tableName) == true) {
                // Declare data
                $columns = [
                    'phone' => [
                        'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                        'length' => 100,
                        'nullable' => true,
                        'comment' => 'Phone'
                    ]
                ];

                $connection = $setup->getConnection();
                foreach ($columns as $name => $definition) {
                    $connection->addColumn($tableName, $name, $definition);
                }
            }

        }
        
        if (version_compare($context->getVersion(), '1.0.19 ') < 0) {

            //code to upgrade to 1.0.19
            // Get module table

            $tableName = $setup->getTable('filoblu_newsletter_subscriber_info');

            // Check if the table already exists
            if ($setup->getConnection()->isTableExists($tableName) == true) {
                // Declare data
                $columns = [
                    'created_at' => [
                        'type' => \Magento\Framework\DB\Ddl\Table::TYPE_DATETIME,
                        'length' => null,
                        'nullable' => true,
                        'comment' => 'Created At'
                    ],
                    'updated_at' => [
                        'type' => \Magento\Framework\DB\Ddl\Table::TYPE_DATETIME,
                        'length' => null,
                        'nullable' => true,
                        'comment' => 'Updated At'
                    ]
                ];

                $connection = $setup->getConnection();
                foreach ($columns as $name => $definition) {
                    $connection->addColumn($tableName, $name, $definition);
                }
            }

        }

        if (version_compare($context->getVersion(), '1.0.21') < 0) {

            //code to upgrade to 1.0.21
            $tableName = $setup->getTable('filoblu_newsletter_preconfirm');

            // Check if the table already exists
            if ($setup->getConnection()->isTableExists($tableName) == true) {
                // Declare data
                $columns = [
                    'code' => [
                        'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                        'length' => 50,
                        'nullable' => true,
                        'comment' => 'Code'
                    ]
                ];

                $connection = $setup->getConnection();
                foreach ($columns as $name => $definition) {
                    $connection->addColumn($tableName, $name, $definition);
                }
            }

            $tableName = $setup->getTable('filoblu_newsletter_thankyou');

            // Check if the table already exists
            if ($setup->getConnection()->isTableExists($tableName) == true) {
                // Declare data
                $columns = [
                    'code' => [
                        'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                        'length' => 50,
                        'nullable' => true,
                        'comment' => 'Code'
                    ]
                ];

                $connection = $setup->getConnection();
                foreach ($columns as $name => $definition) {
                    $connection->addColumn($tableName, $name, $definition);
                }
            }
        }

        if (version_compare($context->getVersion(), '1.0.22') < 0) {

            //code to upgrade to 1.0.22
            $tableName = $setup->getTable('filoblu_newsletter_subscriber_info');

            // Check if the table already exists
            if ($setup->getConnection()->isTableExists($tableName) == true) {
                // Declare data
                $columns = [
                    'updated_source' => [
                        'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                        'length' => 50,
                        'nullable' => true,
                        'comment' => 'Updated Source'
                    ]
                ];

                $connection = $setup->getConnection();
                foreach ($columns as $name => $definition) {
                    $connection->addColumn($tableName, $name, $definition);
                }
            }
        }

        /**
         * Create field to support customer group assignment on landing page registration
         */
        if (version_compare($context->getVersion(), '1.0.23') < 0) {

            $tableName = $setup->getTable('filoblu_newsletter_landing');

            if ($setup->tableExists('filoblu_newsletter_landing')) {

                // Declare data
                $columns = [
                    'assign_customer_group' => [
                        'type' => \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
                        'nullable' => false,
                        'default' => '0',
                        'comment' => 'Assign to customer group. 0 = no, 1 = yes'
                    ],
                    'customer_group' => [
                        'type' => \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
                        'nullable' => true,
                        'default' => 0,
                        'comment' => 'Customer group.'
                    ]
                ];

                $connection = $setup->getConnection();
                foreach ($columns as $name => $definition) {
                    $connection->addColumn($tableName, $name, $definition);
                }
            }
        }

        $setup->endSetup();
    }

}
