<?php

namespace FiloBlu\Newsletter\Setup;

use Magento\Framework\Setup\InstallSchemaInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\SchemaSetupInterface;

/**
 * @codeCoverageIgnore
 */
class InstallSchema implements InstallSchemaInterface {

    /**
     * {@inheritdoc}
     */
    public function install(SchemaSetupInterface $setup, ModuleContextInterface $context) {
        $installer = $setup;

        $installer->startSetup();

        /**
         * Create table 'filoblu_newsletter_subscriber_info'
         */
        if (!$installer->tableExists('filoblu_newsletter_subscriber_info')) {
            $table = $installer->getConnection()->newTable(
                            $installer->getTable('filoblu_newsletter_subscriber_info'))
                    ->addColumn(
                            'subscriber_id', \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER, null, [
                        'unsigned' => true,
                        'nullable' => false,
                        'primary' => true,
                            ], 'Subscriber Id'
                    )->addColumn(
                            'firstname', 
                            \Magento\Framework\DB\Ddl\Table::TYPE_TEXT, 
                            255, 
                            ['nullable' => true], 
                            'First Name'
                    )
                    ->addColumn(
                            'lastname', 
                            \Magento\Framework\DB\Ddl\Table::TYPE_TEXT, 
                            255, 
                            ['nullable' => true], 
                            'Last Name'
                    )
                    ->addColumn(
                            'dob',
                            \Magento\Framework\DB\Ddl\Table::TYPE_TIMESTAMP,
                            null,
                            ['nullable' => true, 'default' => \Magento\Framework\DB\Ddl\Table::TIMESTAMP_INIT],
                            'Date Of Birth'
                )        
                    ->addColumn(
                            'country', 
                            \Magento\Framework\DB\Ddl\Table::TYPE_TEXT, 
                            50, 
                            ['nullable' => true], 
                            'Country'
                    )
                    ->addIndex(
                            $setup->getIdxName('filoblu_newsletter_subscriber_info', ['subscriber_id']), ['subscriber_id']
                    )
                    ->addForeignKey(
                            $setup->getFkName(
                                    'filoblu_newsletter_subscriber_info', 'subscriber_id', 'newsletter_subscriber', 'subscriber_id'
                            ), 'subscriber_id', $setup->getTable('newsletter_subscriber'), 'subscriber_id', \Magento\Framework\DB\Ddl\Table::ACTION_CASCADE, \Magento\Framework\DB\Ddl\Table::ACTION_CASCADE
                    )
                    ->setComment(
                    'subscriber additional info'
            );
            $installer->getConnection()->createTable($table);
        }

        $installer->endSetup();
    }

}
