<?php

namespace FiloBlu\Newsletter\Model\ThankYou\Source;

use FiloBlu\Newsletter\Model\ThankYou;
use Magento\Framework\Data\OptionSourceInterface;

class IsEnabled implements OptionSourceInterface
{

    protected $thankYouPage;

    public function __construct(ThankYou $thankYouPage)
    {
        $this->thankYouPage = $thankYouPage;
    }

    /**
     * Get options
     *
     * @return array
     */
    public function toOptionArray()
    {
        $options[] = ['label' => '', 'value' => ''];
        $availableOptions = $this->thankYouPage->getAvailableStatuses();

        foreach ($availableOptions as $key => $value) {
            $options[] = [
                'label' => $value,
                'value' => $key,
            ];
        }
        return $options;
    }
}