<?php

namespace FiloBlu\Newsletter\Model;

use FiloBlu\Newsletter\Model\ResourceModel\ThankYou\CollectionFactory;
use Magento\Framework\Data\Collection\AbstractDb;
use Magento\Framework\Model\AbstractModel;
use Magento\Framework\Model\Context;
use Magento\Framework\Model\ResourceModel\AbstractResource;
use Magento\Framework\Registry;
use Magento\Store\Model\StoreManagerInterface;

class ThankYou extends AbstractModel
{
    protected $thankYouPageCollectionFactory;

    /**
     * Store manager
     *
     * @var StoreManagerInterface
     */
    protected $_storeManager;

    /**
     * ThankYou constructor.
     * @param CollectionFactory $thankYouPageCollectionFactory
     * @param StoreManagerInterface $_storeManager
     * @param Context $context
     * @param Registry $registry
     * @param AbstractResource|null $resource
     * @param AbstractDb|null $resourceCollection
     * @param array $data
     */
    public function __construct(
        CollectionFactory $thankYouPageCollectionFactory,
        StoreManagerInterface $_storeManager,
        Context $context,
        Registry $registry,
        AbstractResource $resource = null,
        AbstractDb $resourceCollection = null,
        array $data = []
    )
    {
        parent::__construct($context, $registry, $resource, $resourceCollection, $data);
        $this->thankYouPageCollectionFactory = $thankYouPageCollectionFactory;
        $this->_storeManager = $_storeManager;
    }

    public function getAvailableStatuses()
    {
        return [
            0 => 'Disabled',
            1 => 'Enabled'
        ];
    }

    public function beforeSave()
    {
        if (is_array($this->getData('store_ids'))) {
            $this->setData('store_ids', implode(',', $this->getData('store_ids')));
        }
        return parent::beforeSave();
    }

    public function getAllUrlThankYouPage()
    {
        $collection = $this->getAllThankYouPage();
        $collection->addFieldToSelect(['url_key', 'require_cookie']);

        return $collection;
    }

    public function getAllThankYouPage()
    {
        $collection = $this->thankYouPageCollectionFactory->create();
        $collection->addFieldToFilter('enabled', ["eq" => 1]);
        $collection->addStoreFilter($this->_storeManager->getStore()->getId());

        return $collection;
    }

    public function getUrlThankYouPageById($id)
    {
        $collection = $this->getAllThankYouPage();
        $collection->addFieldToFilter('thankyou_id', ['eq' => $id]);
        $collection->addFieldToSelect(['url_key']);

        return $collection->getFirstItem();
    }

    public function getThankYouPageById($id)
    {
        $collection = $this->getAllThankYouPage();
        $collection->addFieldToFilter('thankyou_id', ['eq' => $id]);

        return $collection->getFirstItem();
    }

    public function getThankYouPageList()
    {
        $collection = $this->thankYouPageCollectionFactory->create();
        $collection->addFieldToSelect(['title', 'url_key']);

        return $collection;
    }

    public function getThankYouPageListArray()
    {
        $collection = $this->thankYouPageCollectionFactory->create();
        $collection->addFieldToSelect(['title', 'url_key']);

        $array = [0 => 'None'];
        foreach ($collection->getData() as $value) {
            $array[$value['thankyou_id']] = "{$value['title']} - {$value['url_key']}";
        }

        return $array;
    }

    /**
     * Initialize resource model
     *
     * @return void
     */
    protected function _construct()
    {
        $this->_init(ResourceModel\ThankYou::class);
    }
}
