<?php

namespace FiloBlu\Newsletter\Model;

use Magento\Framework\Data\Collection\AbstractDb;
use Magento\Framework\Model\AbstractModel;
use Magento\Framework\Model\Context;
use Magento\Framework\Model\ResourceModel\AbstractResource;
use Magento\Framework\Registry;
use Magento\Framework\Stdlib\DateTime\DateTime;

/**
 * Class SubscriberInfo
 * @package FiloBlu\Newsletter\Model
 */
class SubscriberInfo extends AbstractModel
{
    /**
     * @var DateTime
     */
    protected $date;

    /**
     * SubscriberInfo constructor.
     * @param Context $context
     * @param Registry $registry
     * @param DateTime $date
     * @param AbstractResource|null $resource
     * @param AbstractDb|null $resourceCollection
     * @param array $data
     */
    public function __construct(
        Context $context,
        Registry $registry,
        DateTime $date,
        AbstractResource $resource = null,
        AbstractDb $resourceCollection = null,
        array $data = []
    ) {
        parent::__construct($context, $registry, $resource, $resourceCollection, $data);
        $this->date = $date;
    }

    /**
     * @return AbstractModel
     */
    public function beforeSave()
    {
        $currentDate = $this->date->gmtDate();
        if (!$this->getCreatedAt()) {
            $this->setCreatedAt($currentDate);
        }
        $this->setUpdatedAt($currentDate);

        return parent::beforeSave();
    }

    /**
     * Initialize resource model
     *
     * @return void
     */
    protected function _construct()
    {
        $this->_init(ResourceModel\SubscriberInfo::class);
    }
}
