<?php
/**
 * Newsletter subscriber grid collection
 *
 * Copyright © 2016 Magento. All rights reserved.
 * See COPYING.txt for license details.
 */
namespace FiloBlu\Newsletter\Model\Plugin\Subscriber\Grid;

class Collection
{
    /**
     * Sets flag for customer info loading on load
     *
     * @param $collection
     * @return $this
     */
    public function afterShowCustomerInfo($collection)
    {
		$collection->getSelect()->joinLeft(
            [
                'filoblu_newsletter_subscriber_info' => $collection->getTable('filoblu_newsletter_subscriber_info')
            ],
            'main_table.subscriber_id = filoblu_newsletter_subscriber_info.subscriber_id',
            [
                'filoblu_subscriber_id' => 'subscriber_id',
                'filoblu_firstname' => 'firstname',
                'filoblu_lastname' => 'lastname',
                'filoblu_dob' => 'dob',
                'filoblu_country' => 'country',
                'filoblu_gender' => 'gender',
                'filoblu_collections' => 'collections',
                'filoblu_source' => 'source',
                'filoblu_language' => 'language',
                'filoblu_website_name' => 'website_name',
                'filoblu_birthday' => 'birthday',
                'filoblu_phone' => 'phone',
                'filoblu_created_at' => 'created_at',
                'filoblu_updated_at' => 'updated_at',
                'filoblu_updated_source' => 'updated_source',
                ]
        );
        return $collection;
    }
}
