<?php

namespace FiloBlu\Newsletter\Model\Plugin;

use Exception;
use FiloBlu\Newsletter\Block\Widget\Gender;
use FiloBlu\Newsletter\Helper\Data;
use FiloBlu\Newsletter\Model\SubscriberInfoFactory;
use Magento\Directory\Model\CountryFactory;
use Magento\Directory\Model\RegionFactory;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\App\Response\Http;
use Magento\Framework\ObjectManagerInterface;
use Magento\Store\Model\ScopeInterface;
use Magento\Store\Model\StoreManagerInterface;
use Psr\Log\LoggerInterface;

/**
 * Class Subscriber
 * @package FiloBlu\Newsletter\Model\Plugin
 */
class Subscriber
{

    /**
     * Helper
     *
     * @var Data
     */
    public $_helper;
    protected $_objectManager;
    protected $request;
    protected $scopeConfig;
    protected $_subscriberInfoFactory;

    /**
     * @var Http
     */
    protected $response;
    /**
     * @var StoreManagerInterface
     */
    protected $storeManager;
    /**
     * @var RegionFactory
     */
    private $regionFactory;
    /**
     * @var Gender
     */
    private $gender;
    /**
     * @var LoggerInterface
     */
    private $logger;


    /**
     * Subscriber constructor.
     * @param ObjectManagerInterface $objectManager
     * @param \Magento\Framework\App\Request\Http $request
     * @param Data $helper
     * @param SubscriberInfoFactory $subscriberInfoFactory
     * @param Http $response
     * @param ScopeConfigInterface $scopeConfig
     * @param StoreManagerInterface $storeManager
     * @param RegionFactory $regionFactory
     * @param Gender $gender
     * @param LoggerInterface $logger
     */
    public function __construct(
        ObjectManagerInterface $objectManager,
        \Magento\Framework\App\Request\Http $request,
        Data $helper,
        SubscriberInfoFactory $subscriberInfoFactory,
        Http $response,
        ScopeConfigInterface $scopeConfig,
        StoreManagerInterface $storeManager,
        RegionFactory $regionFactory,
        Gender $gender,
        LoggerInterface $logger
    )
    {
        $this->_objectManager = $objectManager;
        $this->request = $request;
        $this->_helper = $helper;
        $this->_subscriberInfoFactory = $subscriberInfoFactory;
        $this->response = $response;
        $this->scopeConfig = $scopeConfig;
        $this->storeManager = $storeManager;
        $this->regionFactory = $regionFactory;
        $this->gender = $gender;
        $this->logger = $logger;
    }

    /**
     * @param $subscriber
     * @param $email
     * @return mixed
     * @throws Exception
     */
    public function afterSubscribe($subscriber, $result, $email)
    {
        if ($this->_helper->getConfig('popup/enabled') && !$this->_helper->getPopupCookie()) {
            $this->_helper->setPopupCookie();
        }

        $post = $this->request->getPost();

        if (empty($post)) {
            return $result;
        }

        if ($this->_helper->getConfig('general/enabled')) {

            $fieldsMapping = unserialize($this->_helper->getConfig('general/fields_mapping'));

            if ($fieldsMapping && count($fieldsMapping)) {

                $store =  $this->storeManager->getStore($subscriber->getStoreId());
                $language = $this->_helper->getStoreLanguage( $subscriber->getStoreId());
                $webSiteName = $store->getWebsite()->getName();

                if (empty($post['language'])) {
                    $post['language'] = $language;
                }
                if (empty($post['website_name'])) {
                    $post['website_name'] = $webSiteName;
                }
                if (empty($post['source'])) {
                    $post['source'] = 'REGISTRATION';
                }
                if (empty($post['country_id'])) {
                    $post['country_id'] = $this->_helper->getDefaultCountryByWebsite($store->getWebsite()->getId());
                }

                $model = $this->_subscriberInfoFactory->create();
                $model->setSubscriberId($subscriber->getSubscriberId());

                foreach ($fieldsMapping as $field) {
                    if (isset($post[$field['postname']])) {
                        if (is_array($post[$field['postname']])) {
                            $valStr = '';
                            foreach ($post[$field['postname']] as $val) {
                                if (is_string($val)) {
                                    if ($valStr) {
                                        $valStr .= ' | ' . $val;
                                    } else {
                                        $valStr = $val;
                                    }
                                }
                            }

                            if ($valStr) {
                                $model->setData($field['dbcolumnname'], $valStr);
                            }
                        } else {

                            $val = $post[$field['postname']];

                            if ($field['dbcolumnname'] == 'gender') {
                                $val = $this->getGender($val);
                            }

                            $model->setData($field['dbcolumnname'], $val);
                        }
                    }
                }

                $model->save();
            }
        }
        return $result;
    }

    /**
     * @param $subscriber
     * @param $customerId
     * @return mixed
     * @throws Exception
     */
    public function afterSubscribeCustomerById($subscriber, $result, $customerId)
    {
        if ($this->_helper->getConfig('popup/enabled') && !$this->_helper->getPopupCookie()) {
            $this->_helper->setPopupCookie();
        }

        if ($this->_helper->getConfig('general/enabled')) {

            $fieldsMapping = unserialize($this->_helper->getConfig('general/fields_mapping'));

            if ($fieldsMapping && count($fieldsMapping)) {
                $post = $this->request->getPost();

                $store =  $this->storeManager->getStore($result->getStoreId());
                $language = $this->_helper->getStoreLanguage( $result->getStoreId());
                $webSiteName = $store->getWebsite()->getName();

                if (empty($post['language'])) {
                    $post['language'] = $language;
                }
                if (empty($post['website_name'])) {
                    $post['website_name'] = $webSiteName;
                }
                if (empty($post['source'])) {
                    $post['source'] = 'REGISTRATION';
                }
                if (empty($post['country_id'])) {
                    $post['country_id'] = $this->_helper->getDefaultCountryByWebsite($store->getWebsite()->getId());
                }

                $model = $this->_subscriberInfoFactory->create();
                $model->setSubscriberId($subscriber->getSubscriberId());

                foreach ($fieldsMapping as $field) {

                    if (isset($post[$field['postname']])) {
                        if (is_array($post[$field['postname']])) {
                            $valStr = '';
                            foreach ($post[$field['postname']] as $val) {
                                if (is_string($val)) {
                                    if ($valStr) {
                                        $valStr .= ' | ' . $val;
                                    } else {
                                        $valStr = $val;
                                    }
                                }
                            }

                            if ($valStr) {
                                $model->setData($field['dbcolumnname'], $valStr);
                            }
                        } else {
                            $model->setData($field['dbcolumnname'], $post[$field['postname']]);
                        }
                    }
                }

                $model->save();
            }
        }
        return $customerId;
    }

    /**
     * Confirms subscriber newsletter
     *
     * @param $subscriber
     * @param $code
     * @return boolean
     */
    public function afterConfirm($subscriber, $code)
    {

        if ($this->_helper->getConfig("general/enabled") && $subscriber->getCode() === $code) {

            $params = $this->request->getParams();

            if (isset($params['thankyou_id']) && (int)$params['thankyou_id'] !== 0) {
                $this->_helper->setThankYouCookie($params['thankyou_id']);
            }

        }
        return $code;
    }

    /**
     * @param $subscriber
     * @param $result
     * @return string
     */
    public function afterGetConfirmationLink($subscriber, $result)
    {
        if ($this->_helper->getConfig('general/enabled')) {
            $params = $this->request->getParams();

            $fieldsMapping = unserialize($this->_helper->getConfig('general/fields_preconfirm_get'));

            foreach ($params as $key => $value) {

                $addParam = false;

                if ($fieldsMapping && count($fieldsMapping)) {

                    foreach ($fieldsMapping as $field) {

                        if ($key === $field['getname']) {
                            $addParam = true;
                            break;
                        }
                    }
                }

                if ($key === 'thankyou_id') {
                    $addParam = true;
                }

                if ($addParam) {
                    $result .= $key . '/' . urlencode($value) . '/';
                }
            }
        }

        return $result;
    }

    /**
     * @param \Magento\Newsletter\Model\Subscriber $subject
     */
    public function beforeSendConfirmationSuccessEmail(\Magento\Newsletter\Model\Subscriber $subject)
    {
        $subject->setImportMode($this->scopeConfig->isSetFlag('filoblu_newsletter_section/general/disable_newsletter_confirmation_success_email', ScopeInterface::SCOPE_STORE));
    }

    public function getGender($genderValue)
    {
        $genderOptions = $this->gender->getGenderOptions();
        foreach ($genderOptions as $gender) {
            if ($gender->getValue() == (int)$genderValue) {
                return $gender->getLabel() ?? $genderValue;
            }
        }

        return $genderValue;
    }
}
