<?php
namespace FiloBlu\Newsletter\Model\LandingPage\Source;

use FiloBlu\Newsletter\Model\LandingPage;
use Magento\Framework\Data\OptionSourceInterface;

class IsEnabled implements OptionSourceInterface
{
    /**
     * @var LandingPage
     */
    protected $landingPage;

    public function __construct(LandingPage $landingPage)
    {
        $this->landingPage = $landingPage;
    }

    /**
     * Get options
     *
     * @return array
     */
    public function toOptionArray()
    {
        $options[] = ['label' => '', 'value' => ''];
        $availableOptions = $this->landingPage->getAvailableStatuses();

        foreach ($availableOptions as $key => $value) {
            $options[] = [
                'label' => $value,
                'value' => $key,
            ];
        }
        return $options;
    }
}