<?php

namespace FiloBlu\Newsletter\Model\Config\Backend;

use Magento\Framework\App\Config\Value;

/**
 * @api
 * @since 100.0.2
 */
class Serialized extends Value
{
    /**
     * @return void
     */
    protected function _afterLoad()
    {
        if (!is_array($this->getValue())) {
            $value = $this->getValue();
            $this->setValue(empty($value) ? false : unserialize($value));
        }
    }

    /**
     * @return $this
     */
    public function beforeSave()
    {
        if (is_array($this->getValue())) {
            $this->setValue(serialize($this->getValue()));
        }
        return parent::beforeSave();
    }
}
