<?php

/**
 * Copyright © 2016 Magento. All rights reserved.
 * See COPYING.txt for license details.
 */

namespace FiloBlu\Newsletter\Magento\Framework\View\Element\Html;

/**
 * Date element block
 */
class Date extends \Magento\Framework\View\Element\Html\Date {

    /**
     * Render block HTML
     *
     * @return string
     * @SuppressWarnings(PHPMD.NPathComplexity)
     */
    protected function _toHtml() {
        $html = '<input type="text" readonly name="' . $this->getName() . '" id="' . $this->getId() . '" ';
        $html .= 'value="' . $this->escapeHtml($this->getValue()) . '" ';
        $html .= 'class="' . $this->getClass() . '" ' . $this->getExtraParams() . '/> ';
        $calendarYearsRange = $this->getYearsRange();
        $changeMonth = $this->getChangeMonth();
        $changeYear = $this->getChangeYear();
        $maxDate = $this->getMaxDate();
        $showOn = $this->getShowOn();

        $html .= '<script type="text/javascript">
            require(["jquery", "mage/calendar"], function($){
                    $("#' .
                $this->getId() .
                '").calendar({
                        showsTime: ' .
                ($this->getTimeFormat() ? 'true' : 'false') .
                ',
                        ' .
                ($this->getTimeFormat() ? 'timeFormat: "' .
                $this->getTimeFormat() .
                '",' : '') .
                '
                        dateFormat: "' .
                $this->getDateFormat() .
                '",
                        buttonImage: "' .
                $this->getImage() .
                '",
                        ' .
                ($calendarYearsRange ? 'yearRange: "' .
                $calendarYearsRange .
                '",' : '') .
                '
                        buttonText: "' .
                (string) new \Magento\Framework\Phrase(
                'Select Date'
                ) .
                '"' . ($maxDate ? ', maxDate: "' . $maxDate . '"' : '') .
                ($changeMonth === null ? '' : ', changeMonth: ' . $changeMonth) .
                ($changeYear === null ? '' : ', changeYear: ' . $changeYear) .
                ($showOn ? ', showOn: "' . $showOn . '"' : '') .
                '})

                    $("#' .
                $this->getId() .
                '").datepicker()
                    .on("change", function (dataText, inst) {

                        var date = $(this).datepicker("getDate"),
                         day  = date.getDate(),
                         month = date.getMonth() + 1,
                         year =  date.getFullYear();

                        $("#' . $this->getId() . '-value").val(year + "-" + month + "-" + day);
                        $("#' . $this->getId() . '-birthday").val(month + "/" + day);
                    });
                    
                        var date = $("#' . $this->getId() . '").datepicker("getDate");
                        if (date) {
                            var day  = date.getDate(),
                            month = date.getMonth() + 1,
                            year =  date.getFullYear();

                           $("#' . $this->getId() . '-value").val(year + "-" + month + "-" + day);
                           $("#' . $this->getId() . '-birthday").val(month + "/" + day);
                        }
            });
            </script>';

        return $html;
    }

}
