<?php

namespace FiloBlu\Newsletter\CustomerData;

use FiloBlu\Newsletter\Helper\Data;
use Magento\Customer\CustomerData\SectionSourceInterface;
use Magento\Newsletter\Model\Subscriber;
use Magento\Customer\Model\Session;
use Magento\Newsletter\Model\SubscriberFactory;

/**
 *
 */
class NewsletterConfig implements SectionSourceInterface
{
    /**
     * @var \FiloBlu\Newsletter\Helper\Data
     */
    protected $helper;
    /**
     * @var \Magento\Customer\Model\Session
     */
    protected $_customerSession;
    /**
     * @var \Magento\Newsletter\Model\SubscriberFactory
     */
    protected $_subscriberFactory;

    /**
     * @param \FiloBlu\Newsletter\Helper\Data $helper
     * @param \Magento\Customer\Model\Session $customerSession
     * @param \Magento\Newsletter\Model\SubscriberFactory $subscriberFactory
     */
    public function __construct(
        Data $helper,
        Session $customerSession,
        SubscriberFactory $subscriberFactory
    ) {
        $this->helper = $helper;
        $this->_customerSession = $customerSession;
        $this->_subscriberFactory = $subscriberFactory;
    }

    /**
     * {@inheritdoc}
     */
    public function getSectionData()
    {
        return [
            'is_already_subscribed' => $this->customerAlreadySubscribed(),
        ];
    }

    /**
     * @return bool
     */
    private function customerAlreadySubscribed()
    {
        $isSubscribed = false;

        if ($this->_customerSession->isLoggedIn()) {
            $email = $this->_customerSession->getCustomerDataObject()->getEmail();

            $subscriber = $this->_subscriberFactory->create()->loadByEmail($email);

            if ($subscriber->getSubscriberStatus() == Subscriber::STATUS_SUBSCRIBED) {
                $isSubscribed = true;
            }
        }

        return $isSubscribed;
    }
}
