<?php

namespace FiloBlu\Newsletter\Controller;

use FiloBlu\Newsletter\Helper\Data;
use FiloBlu\Newsletter\Model\LandingPage;
use FiloBlu\Newsletter\Model\PreConfirm;
use FiloBlu\Newsletter\Model\ThankYou;
use Magento\Framework\App\ActionFactory;
use Magento\Framework\App\ActionInterface;
use Magento\Framework\App\RequestInterface;
use Magento\Framework\App\RouterInterface;
use Magento\Framework\UrlInterface;

class Router implements RouterInterface
{

    /**
     * @var ActionFactory
     */
    protected $actionFactory;
    protected $_helper;
    protected $_modelLanding;
    protected $_modelPreConfirm;
    protected $_modelThankYou;

    public function __construct(
        ActionFactory $actionFactory,
        Data $helper,
        LandingPage $modelLanding,
        PreConfirm $modelPreConfirm,
        ThankYou $modelThankYou
    ) {
        $this->actionFactory = $actionFactory;
        $this->_helper = $helper;
        $this->_modelLanding = $modelLanding;
        $this->_modelPreConfirm = $modelPreConfirm;
        $this->_modelThankYou = $modelThankYou;
    }

    /**
     *
     * Validate and Match Cms Page and modify request
     *
     * @param RequestInterface $request
     * @return ActionInterface
     */
    public function match(RequestInterface $request)
    {
        if (!$this->_helper->getConfig('general/enabled')) {
            return null;
        }

        foreach ($this->_modelLanding->getAllUrlLandingPage()->getData() as $value) {
            $path = trim($request->getPathInfo(), '/');

            if ($path == $value['url_key']) {
                $request->setAlias(UrlInterface::REWRITE_REQUEST_PATH_ALIAS, $path);
                $request->setPathInfo("/newsletterajax/index/landingpage/landing_id/{$value['landing_id']}");

                return $this->actionFactory->create('Magento\Framework\App\Action\Forward');
            }
        }

        foreach ($this->_modelPreConfirm->getAllUrlPreConfirmPage()->getData() as $value) {
            if ($value['require_cookie'] && !$this->_helper->getPreConfirmCookie($value['preconfirm_id'])) {
                continue;
            }

            $path = trim($request->getPathInfo(), '/');

            if ($path == $value['url_key']) {
                $this->_helper->deletePreConfirmCookie($value['preconfirm_id']);
                $request->setAlias(UrlInterface::REWRITE_REQUEST_PATH_ALIAS, $path);
                $request->setPathInfo("/newsletterajax/index/preconfirm/preconfirm_id/{$value['preconfirm_id']}");

                return $this->actionFactory->create('Magento\Framework\App\Action\Forward');
            }
        }

        foreach ($this->_modelThankYou->getAllUrlThankYouPage()->getData() as $value) {
            if ($value['require_cookie'] && !$this->_helper->getThankYouCookie($value['thankyou_id'])) {
                continue;
            }

            $path = trim($request->getPathInfo(), '/');

            if ($path == $value['url_key']) {
                $this->_helper->deleteThankYouCookie($value['thankyou_id']);
                $request->setAlias(UrlInterface::REWRITE_REQUEST_PATH_ALIAS, $path);
                $request->setPathInfo("/newsletterajax/index/thankyou/thankyou_id/{$value['thankyou_id']}");

                return $this->actionFactory->create('Magento\Framework\App\Action\Forward');
            }
        }

        return null;
    }
}
