<?php

/**
 * Copyright © 2016 Magento. All rights reserved.
 * See COPYING.txt for license details.
 */

namespace FiloBlu\Newsletter\Controller\Index;

/**
 * Responsible for loading page content.
 *
 * This is a basic controller that only loads the corresponding layout file. It may duplicate other such
 * controllers, and thus it is considered tech debt. This code duplication will be resolved in future releases.
 */
class ThankYou extends \Magento\Framework\App\Action\Action
{

    /** @var \Magento\Framework\View\Result\PageFactory */
    protected $resultPageFactory;
    protected $_helper;
    protected $_coreRegistry;
    protected $_modelThankYou;
    protected $layoutFactory;

    public function __construct(
        \Magento\Framework\App\Action\Context $context, \Magento\Framework\View\Result\PageFactory $resultPageFactory, \FiloBlu\Newsletter\Helper\Data $helper, \Magento\Framework\Registry $registry, \FiloBlu\Newsletter\Model\ThankYou $modelThankYou, \Magento\Framework\View\Page\Config $layoutFactory
    )
    {
        $this->resultPageFactory = $resultPageFactory;
        $this->_helper = $helper;
        $this->_coreRegistry = $registry;
        $this->_modelThankYou = $modelThankYou;
        $this->layoutFactory = $layoutFactory;
        parent::__construct($context);
    }

    public function execute()
    {

        $this->layoutFactory->setRobots('NOINDEX,NOFOLLOW');

        if ($this->_helper->getConfig("general/enabled")) {
            $resultPage = $this->resultPageFactory->create();
            $model = $this->_modelThankYou->getThankYouPageById($this->getRequest()->getParam('thankyou_id'));

            if ($model->getCode()) {
                $resultPage->addHandle('filoblunewsletterfrontend_index_thankyou_' . $model->getCode());
            }

            $this->_coreRegistry->register('newsletter_thankyoupage_entity', $model);
            $resultPage->getConfig()->getTitle()->set($model->getData()["title"]);

            return $resultPage;
        } else {
            return null;
        }
    }

}
