<?php

/**
 * Copyright © 2016 Magento. All rights reserved.
 * See COPYING.txt for license details.
 */

namespace FiloBlu\Newsletter\Controller\Index;

/**
 * Responsible for loading page content.
 *
 * This is a basic controller that only loads the corresponding layout file. It may duplicate other such
 * controllers, and thus it is considered tech debt. This code duplication will be resolved in future releases.
 */
class PreConfirm extends \Magento\Framework\App\Action\Action
{

    /** @var \Magento\Framework\View\Result\PageFactory */
    protected $resultPageFactory;
    protected $_helper;
    protected $_coreRegistry;
    protected $_modelPreConfirm;
    protected $layoutFactory;

    public function __construct(
        \Magento\Framework\App\Action\Context $context, \Magento\Framework\View\Result\PageFactory $resultPageFactory, \FiloBlu\Newsletter\Helper\Data $helper, \Magento\Framework\Registry $registry, \FiloBlu\Newsletter\Model\PreConfirm $modelPreConfirm, \Magento\Framework\View\Page\Config $layoutFactory
    )
    {
        $this->resultPageFactory = $resultPageFactory;
        $this->_helper = $helper;
        $this->_coreRegistry = $registry;
        $this->_modelPreConfirm = $modelPreConfirm;
        $this->layoutFactory = $layoutFactory;
        parent::__construct($context);
    }

    public function execute()
    {

        $this->layoutFactory->setRobots('NOINDEX,NOFOLLOW');

        if ($this->_helper->getConfig("general/enabled")) {
            $resultPage = $this->resultPageFactory->create();
            $model = $this->_modelPreConfirm->getPreConfirmPageById($this->getRequest()->getParam('preconfirm_id'));

            if ($model->getCode()) {
                $resultPage->addHandle('filoblunewsletterfrontend_index_preconfirm_' . $model->getCode());
            }

            $this->_coreRegistry->register('newsletter_preconfirmpage_entity', $model);
            $resultPage->getConfig()->getTitle()->set($model->getData()["title"]);

            return $resultPage;
        } else {
            return null;
        }
    }

}
