<?php

namespace FiloBlu\Newsletter\Controller\Index;

use FiloBlu\Newsletter\Helper\Data;
use FiloBlu\Newsletter\Model\SubscriberInfoFactory;
use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\Registry;
use Magento\Framework\View\Page\Config;
use Magento\Framework\View\Result\PageFactory;
use Magento\Newsletter\Model\SubscriberFactory;
use Magento\Store\Model\StoreManagerInterface;

/**
 * Responsible for loading page content.
 *
 * This is a basic controller that only loads the corresponding layout file. It may duplicate other such
 * controllers, and thus it is considered tech debt. This code duplication will be resolved in future releases.
 */
class LandingPage extends Action
{

    /** @var PageFactory */
    protected $resultPageFactory;
    protected $_helper;
    protected $_coreRegistry;
    protected $_modelLanding;
    protected $layoutFactory;
    protected $_storeManager;
    protected $_subscriberFactory;
    protected $_subscriberInfoFactory;

    /**
     * LandingPage constructor.
     * @param Context $context
     * @param PageFactory $resultPageFactory
     * @param Data $helper
     * @param Registry $registry
     * @param \FiloBlu\Newsletter\Model\LandingPage $modelLanding
     * @param Config $layoutFactory
     * @param StoreManagerInterface $storeManager
     * @param SubscriberFactory $subscriberFactory
     * @param SubscriberInfoFactory $subscriberInfoFactory
     */
    public function __construct(
        Context $context,
        PageFactory $resultPageFactory,
        Data $helper,
        Registry $registry,
        \FiloBlu\Newsletter\Model\LandingPage $modelLanding,
        Config $layoutFactory,
        StoreManagerInterface $storeManager,
        SubscriberFactory $subscriberFactory,
        SubscriberInfoFactory $subscriberInfoFactory
    )
    {
        $this->_storeManager = $storeManager;
        $this->resultPageFactory = $resultPageFactory;
        $this->_helper = $helper;
        $this->_coreRegistry = $registry;
        $this->_modelLanding = $modelLanding;
        $this->layoutFactory = $layoutFactory;
        $this->_subscriberFactory = $subscriberFactory;
        $this->_subscriberInfoFactory = $subscriberInfoFactory;
        parent::__construct($context);
    }

    public function execute()
    {

        $this->layoutFactory->setRobots('NOINDEX,NOFOLLOW');

        if ($this->_helper->getConfig("general/enabled")) {
            $resultPage = $this->resultPageFactory->create();
            $model = $this->_modelLanding->getLandingPageById($this->getRequest()->getParam('landing_id'));

            $resultPage->addHandle('filoblunewsletterfrontend_index_landingpage_' . $model->getCode());

            // Newsletter edit
            if ($model->getFormType() == 2) {

                $email = $this->getRequest()->getParam('email');

                if (!$email) {
                    return $this->_redirect($this->_storeManager->getStore()->getBaseUrl() . "no-route");
                }

                $subscriber = $this->_subscriberFactory->create()->loadByEmail($email);

                if ($subscriber->getId()) {
                    $subscriberInfo = $this->_subscriberInfoFactory->create()->load($subscriber->getId());
                    if ($subscriberInfo->getId()) {
                        // Add subscriber info data to subscriber model
                        foreach ($subscriberInfo->getData() as $key => $value) {
                            $subscriber->setData($key, $value);
                        }
                    }

                    $fieldsMappingGetCompare = unserialize($this->_helper->getConfig('general/fields_get_compare_newsletter_edit'));

                    if ($fieldsMappingGetCompare && count($fieldsMappingGetCompare)) {
                        foreach ($fieldsMappingGetCompare as $field) {
                            if ($this->getRequest()->getParam($field['getname'])) {
                                if ($subscriber->getData($field['dbcolumnname']) != $this->getRequest()->getParam($field['getname'])) {
                                    return $this->_redirect($this->_storeManager->getStore()->getBaseUrl() . "no-route");
                                }
                            } else {
                                return $this->_redirect($this->_storeManager->getStore()->getBaseUrl() . 'no-route');
                            }
                        }
                    }

                    $model->setSubscriberModel($subscriber);

                } else {
                    return $this->_redirect($this->_storeManager->getStore()->getBaseUrl() . 'no-route');
                }
            }

            $this->_coreRegistry->register('newsletter_landingpage_entity', $model);
            $resultPage->getConfig()->getTitle()->set($model->getData()['title']);

            return $resultPage;
        }

        return null;
    }

}
