<?php
namespace FiloBlu\Newsletter\Controller\Adminhtml\ThankYou;

use Magento\Backend\App\Action;
use Magento\TestFramework\ErrorLog\Logger;

class Delete extends \Magento\Backend\App\Action
{
    /**
     * {@inheritdoc}
     */
    protected function _isAllowed()
    {
        return $this->_authorization->isAllowed('FiloBlu_Newsletter::newsletter_thankyoulistdelete');
    }

    /**
     * Delete action
     *
     * @return \Magento\Framework\Controller\ResultInterface
     */
    public function execute()
    {
        $id = $this->getRequest()->getParam('thankyou_id');
        /** @var \Magento\Backend\Model\View\Result\Redirect $resultRedirect */
        $resultRedirect = $this->resultRedirectFactory->create();
        if ($id) {
            try {
                $model = $this->_objectManager->create('FiloBlu\Newsletter\Model\ThankYou');
                $model->load($id);
                $model->delete();
                $this->messageManager->addSuccess(__('The thankyou page has been deleted.'));
                return $resultRedirect->setPath('*/*/');
            } catch (\Exception $e) {
                $this->messageManager->addError($e->getMessage());
                return $resultRedirect->setPath('*/*/edit', ['thankyou_id' => $id]);
            }
        }
        $this->messageManager->addError(__('We can\'t find a thankyou page to delete.'));
        return $resultRedirect->setPath('*/*/');
    }
}