<?php

/**
 * Copyright © 2016 Magento. All rights reserved.
 * See COPYING.txt for license details.
 */

namespace FiloBlu\Newsletter\Block\Widget;

use FiloBlu\Newsletter\Magento\Framework\View\Element\Html\Date;
use Magento\Customer\Api\CustomerMetadataInterface;
use Magento\Customer\Helper\Address;
use Magento\Framework\Data\Form\FilterFactory;
use Magento\Framework\View\Element\Template\Context;

/**
 * Class Dob
 *
 * @SuppressWarnings(PHPMD.DepthOfInheritance)
 */
class DobDefault extends \Magento\Customer\Block\Widget\Dob
{

    /**
     * @param Context $context
     * @param Address $addressHelper
     * @param CustomerMetadataInterface $customerMetadata
     * @param \Magento\Framework\View\Element\Html\Date $dateElement
     * @param FilterFactory $filterFactory
     * @param array $data
     */
    public function __construct(
        Context $context,
        Address $addressHelper,
        CustomerMetadataInterface $customerMetadata,
        Date $dateElementNewsletter,
        FilterFactory $filterFactory,
        array $data = []
    )
    {
        $this->dateElement = $dateElementNewsletter;
        parent::__construct($context, $addressHelper, $customerMetadata, $dateElementNewsletter, $filterFactory, $data);
    }

    /**
     * @return void
     */
    public function _construct()
    {
        parent::_construct();
        $this->setTemplate('Magento_Customer::widget/dob.phtml');
    }

    /**
     * @return bool
     */
    public function isRequired()
    {
        return true;
    }

}
