<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */

namespace FiloBlu\Newsletter\Block\Widget;

use FiloBlu\Newsletter\Helper\Data;
use FiloBlu\Newsletter\Serialize\Serializer;
use Magento\Directory\Model\ResourceModel\Country\CollectionFactory;
use Magento\Framework\App\Cache\Type\Config;
use Magento\Framework\App\ObjectManager;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\Json\EncoderInterface;
use Magento\Framework\Profiler;
use Magento\Framework\Serialize\SerializerInterface;
use Magento\Framework\View\Element\Html\Select;
use Magento\Framework\View\Element\Template\Context;

/**
 * @SuppressWarnings(PHPMD.CouplingBetweenObjects)
 */
class Country extends \Magento\Directory\Block\Data
{
    private $serializer;
    /**
     * @var Data
     */
    protected $_helper;

    /**
     * Country constructor.
     * @param Context $context
     * @param \Magento\Directory\Helper\Data $directoryHelper
     * @param EncoderInterface $jsonEncoder
     * @param Config $configCacheType
     * @param \Magento\Directory\Model\ResourceModel\Region\CollectionFactory $regionCollectionFactory
     * @param CollectionFactory $countryCollectionFactory
     * @param Data $helperData
     * @param array $data
     */
    public function __construct(
        Context $context,
        \Magento\Directory\Helper\Data $directoryHelper,
        EncoderInterface $jsonEncoder,
        Config $configCacheType,
        \Magento\Directory\Model\ResourceModel\Region\CollectionFactory $regionCollectionFactory,
        CollectionFactory $countryCollectionFactory,
        Data $helperData,
        array $data = []
    ) {
        parent::__construct($context, $directoryHelper, $jsonEncoder, $configCacheType, $regionCollectionFactory, $countryCollectionFactory, $data);
        $this->_helper = $helperData;
    }

    /**
     * @param null $defValue
     * @param string $name
     * @param string $id
     * @param string $title
     * @return string
     * @throws LocalizedException
     * @throws NoSuchEntityException
     */
    public function getCountryHtmlSelect($defValue = null, $name = 'country_id', $id = 'country', $title = 'Country')
    {
        Profiler::start('TEST: ' . __METHOD__, ['group' => 'TEST', 'method' => __METHOD__]);
        /*if ($defValue === null) {
            $defValue = $this->getCountryId();
        }*/

        $cacheKey = 'NEWSLETTER_DIRECTORY_COUNTRY_SELECT_STORE_' . $this->_storeManager->getStore()->getCode();
        $cache = $this->_configCacheType->load($cacheKey);
        if ($cache) {
            $options = $this->getSerializer()->unserialize($cache);
        } else {
            $options = $this->getCountryCollection()
                ->setForegroundCountries($this->getTopDestinations())
                ->toOptionArray();

            $this->_configCacheType->save($this->getSerializer()->serialize($options), $cacheKey);
        }

        $required = $this->_helper->getConfig('popup/country_required') ? 'true' : 'false';

        $html = $this->getLayout()->createBlock(
            Select::class
        )->setName(
            $name
        )->setId(
            $id
        )->setTitle(
            __($title)
        )->setValue(
            $defValue
        )->setOptions(
            $options
        )->setExtraParams(
            "data-validate=\"{'validate-select': " . $required . "}\""
        )->getHtml();

        Profiler::stop('TEST: ' . __METHOD__);
        return $html;
    }

    /**
     * Get serializer
     *
     * @return SerializerInterface
     * @deprecated 100.2.0
     */
    private function getSerializer()
    {
        if ($this->serializer === null) {
            $this->serializer = ObjectManager::getInstance()
                ->get(Serializer::class);
        }
        return $this->serializer;
    }
}
