<?php

namespace FiloBlu\Newsletter\Block\ThankYou;

use FiloBlu\Newsletter\Helper\Data;
use Magento\Framework\App\Request\Http;
use Magento\Framework\Registry;
use Magento\Framework\UrlInterface;
use Magento\Framework\View\Element\Template;
use Magento\Framework\View\Element\Template\Context;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Cms\Model\Template\FilterProvider;

class ThankYou extends Template
{

    public $_helper;
    protected $request;

    /**
     * Store manager
     *
     * @var StoreManagerInterface
     */
    protected $_storeManager;
    protected $_coreRegistry;

    /**
     * @var FilterProvider
     */
    protected $_filterProvider;

    /**
     * ThankYou constructor.
     * @param Context $context
     * @param Data $helper
     * @param Http $request
     * @param Registry $registry
     * @param array $data
     */
    public function __construct(
        FilterProvider $filterProvider,
        Context $context,
        Data $helper,
        Http $request,
        Registry $registry,
        array $data = []
    ) {
        $this->_filterProvider = $filterProvider;
        $this->_helper = $helper;
        $this->request = $request;
        $this->_storeManager = $context->getStoreManager();
        $this->_coreRegistry = $registry;

        parent::__construct($context, $data);
    }

    public function getImageUrl($image)
    {
        return $this->_storeManager->getStore()->getBaseUrl(UrlInterface::URL_TYPE_MEDIA) . "filoblu/newsletter/thankyoupage/image/{$image}";
    }

    public function _prepareLayout()
    {
        if ($this->getThankYouPage()['code']) {
            $this->pageConfig->addBodyClass('filoblunewsletterfrontend-index-thankyou-' . $this->getThankYouPage()['code']);
        }
        return parent::_prepareLayout();
    }

    public function getDescription($content)
    {
        return $this->_filterProvider->getPageFilter()->filter($content);
    }

    protected function _toHtml()
    {

        if (!$this->_helper->getConfig('general/enabled')) {
            return '';
        }

        $thankYou = $this->getThankYouPage();

        $this->setTemplate("FiloBlu_Newsletter::thankyou/thankyou_page_{$thankYou['code']}.phtml");

        if (!$this->getTemplateFile()) {

            $this->setTemplate('FiloBlu_Newsletter::thankyou/thankyou_page.phtml');
        }

        return parent::_toHtml();
    }

    public function getThankYouPage()
    {

        if (!$this->getThankYouPageEntity()) {
            $this->setThankYouPageEntity($this->_coreRegistry->registry('newsletter_thankyoupage_entity'));
        }

        return $this->getThankYouPageEntity()->getData();
    }
}
