<?php

namespace FiloBlu\Newsletter\Block\PreConfirm;

use FiloBlu\Newsletter\Helper\Data;
use Magento\Framework\App\Request\Http;
use Magento\Framework\Registry;
use Magento\Framework\UrlInterface;
use Magento\Framework\View\Element\Template;
use Magento\Framework\View\Element\Template\Context;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Cms\Model\Template\FilterProvider;

class PreConfirm extends Template
{
    public $_helper;
    protected $request;

    /**
     * Store manager
     *
     * @var StoreManagerInterface
     */
    protected $_storeManager;
    protected $_coreRegistry;

    /**
     * @var FilterProvider
     */
    protected $_filterProvider;

    /**
     * PreConfirm constructor.
     * @param Context $context
     * @param Data $helper
     * @param Http $request
     * @param Registry $registry
     * @param array $data
     */
    public function __construct(
        FilterProvider $filterProvider,
        Context $context,
        Data $helper,
        Http $request,
        Registry $registry,
        array $data = []
    ) {
        $this->_filterProvider = $filterProvider;
        $this->_helper = $helper;
        $this->request = $request;
        $this->_storeManager = $context->getStoreManager();
        $this->_coreRegistry = $registry;

        parent::__construct($context, $data);
    }

    /**
     * @param $image
     * @return string
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getImageUrl($image)
    {
        return $this->_storeManager->getStore()->getBaseUrl(UrlInterface::URL_TYPE_MEDIA) . "filoblu/newsletter/preconfirmpage/image{$image}";
    }

    public function _prepareLayout()
    {
        if ($this->getPreConfirmPage()['code']) {
            $this->pageConfig->addBodyClass('filoblunewsletterfrontend-index-preconfirm-' . $this->getPreConfirmPage()['code']);
        }
        return parent::_prepareLayout();
    }

    public function getPreConfirmPage()
    {
        if (!$this->getPreConfirmPageEntity()) {
            $this->setPreConfirmPageEntity($this->_coreRegistry->registry('newsletter_preconfirmpage_entity'));
        }

        return $this->getPreConfirmPageEntity()->getData();
    }

    public function getDescription($content)
    {
        return $this->_filterProvider->getPageFilter()->filter($content);
    }

    protected function _toHtml()
    {
        if (!$this->_helper->getConfig('general/enabled')) {
            return '';
        }

        $preConfirm = $this->getPreConfirmPage();

        $this->setTemplate("FiloBlu_Newsletter::preconfirm/preconfirm_page_{$preConfirm['code']}.phtml");

        if (!$this->getTemplateFile()) {
            $this->setTemplate('FiloBlu_Newsletter::preconfirm/preconfirm_page.phtml');
        }

        return parent::_toHtml();
    }
}
