<?php

namespace FiloBlu\Newsletter\Block\LandingPage;

use FiloBlu\Newsletter\Helper\Data;
use Magento\Framework\App\Request\Http;
use Magento\Framework\View\Element\Template;
use Magento\Framework\View\Element\Template\Context;

class GetParams extends Template
{
    public $_helper;
    public $request;

    /**
     * GetParams constructor.
     * @param Context $context
     * @param Data $helper
     * @param Http $request
     * @param array $data
     */
    public function __construct(
        Context $context,
        Data $helper,
        Http $request,
        array $data = []
    ) {
        $this->_helper = $helper;
        $this->request = $request;

        parent::__construct($context, $data);
    }

    protected function _toHtml()
    {
        if (!$this->_helper->getConfig('general/enabled')) {
            return '';
        }

        return parent::_toHtml();
    }
}
