<?php

namespace FiloBlu\Newsletter\Block\LandingPage;

use FiloBlu\Newsletter\Block\Widget\Country;
use FiloBlu\Newsletter\Helper\Data;
use Magento\Customer\Model\Session;
use Magento\Framework\Registry;
use Magento\Framework\View\Element\Template;
use Magento\Framework\View\Element\Template\Context;

class FormEdit extends Template
{

    /**
     * Helper
     *
     * @var Data
     */
    public $_helper;
    public $_directoryBlock;

    /**
     * @var Session
     */
    protected $_customerSession;

    protected $_coreRegistry;

    /**
     * FormEdit constructor.
     * @param Context $context
     * @param Data $helper
     * @param Country $directoryBlock
     * @param Session $customerSession
     * @param Registry $registry
     * @param array $data
     */
    public function __construct(
        Context $context,
        Data $helper,
        Country $directoryBlock,
        Session $customerSession,
        Registry $registry, array $data = []
    )
    {
        $this->_helper = $helper;
        $this->_directoryBlock = $directoryBlock;
        $this->_customerSession = $customerSession;
        $this->_coreRegistry = $registry;
        parent::__construct($context, $data);
    }

    public function getCountries($value)
    {
        return $this->_directoryBlock->getCountryHtmlSelect($value);
    }

    public function getCustomerInfo()
    {
        return $this->getLandingPage()["subscriber_model"];
    }

    public function getLandingPage()
    {
        if (!$this->getLandingPageEntity()) {
            $this->setLandingPageEntity($this->_coreRegistry->registry('newsletter_landingpage_entity'));
        }

        return $this->getLandingPageEntity()->getData();
    }

    /**
     * Retrieve form action url and set "secure" param to avoid confirm
     * message when we submit form from secure page to unsecure
     *
     * @return string
     */
    public function getFormActionUrl()
    {
        return $this->getUrl('newsletterajax/subscriber/editlandingaction', ['_secure' => true]);
    }

    protected function _toHtml()
    {
        if (!$this->_helper->getConfig('general/enabled') || $this->getLandingPage()['form_type'] != 2) {
            return '';
        }

        return parent::_toHtml();
    }
}
