<?php

namespace FiloBlu\Newsletter\Block\Adminhtml\ThankYou\Grid\Renderer;

use Magento\Backend\Block\Context;
use Magento\Backend\Block\Widget\Grid\Column\Renderer\AbstractRenderer;
use Magento\Framework\DataObject;
use Magento\Framework\UrlInterface;
use Magento\Store\Model\StoreManagerInterface;

class Image extends AbstractRenderer
{
    private $_storeManager;

    /**
     * Image constructor.
     * @param Context $context
     * @param StoreManagerInterface $storemanager
     * @param array $data
     */
    public function __construct(Context $context, StoreManagerInterface $storemanager, array $data = [])
    {
        $this->_storeManager = $storemanager;
        parent::__construct($context, $data);
        $this->_authorization = $context->getAuthorization();
    }

    /**
     * Renders grid column
     *
     * @param Object $row
     * @return  string
     */
    public function render(DataObject $row)
    {
        if ($this->_getValue($row)) {
            $mediaDirectory = $this->_storeManager->getStore()->getBaseUrl(
                UrlInterface::URL_TYPE_MEDIA
            );
            $imageUrl = $mediaDirectory . '/filoblu/newsletter/thankyoupage/image' . $this->_getValue($row);
            return '<img src="' . $imageUrl . '" width="20" title="' . $this->_getValue($row) . '" alt="' . $this->_getValue($row) . '" "/>';
        }

        return '';
    }
}