<?php

namespace FiloBlu\Newsletter\Block\Adminhtml\LandingPage\Edit\Tab;

use FiloBlu\Newsletter\Model\PreConfirm;
use FiloBlu\Newsletter\Model\ThankYou;
use Magento\Backend\Block\Store\Switcher\Form\Renderer\Fieldset\Element;
use Magento\Backend\Block\Template\Context;
use Magento\Backend\Block\Widget\Form\Generic;
use Magento\Backend\Block\Widget\Tab\TabInterface;
use Magento\Cms\Model\Wysiwyg\Config;
use Magento\Customer\Model\Customer\Source\Group;
use Magento\Framework\Data\FormFactory;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Registry;
use Magento\Store\Model\System\Store;
use FiloBlu\Newsletter\Block\Adminhtml\LandingPage\Helper\Image;
use Magento\Backend\Block\Widget\Form\Element\Dependence;

/**
 *
 */
class LandingPage extends Generic implements TabInterface
{
    /**
     * @var Store
     */
    protected $_systemStore;
    /**
     * @var \FiloBlu\Newsletter\Model\ThankYou
     */
    protected $thankYouPage;
    /**
     * @var \FiloBlu\Newsletter\Model\PreConfirm
     */
    protected $preConfirmPage;
    /**
     * @var Config
     */
    protected $_wysiwyg;
    /**
     * @var Group
     */
    private $customGroupSource;


    /**
     * @param Context $context
     * @param Registry $registry
     * @param FormFactory $formFactory
     * @param Store $systemStore
     * @param Config $wysiwyg
     * @param ThankYou $thankYouPage
     * @param PreConfirm $preConfirmPage
     * @param Group $customGroupSource
     * @param array $data
     */
    public function __construct(
        Context $context,
        Registry $registry,
        FormFactory $formFactory,
        Store $systemStore,
        Config $wysiwyg,
        ThankYou $thankYouPage,
        PreConfirm $preConfirmPage,
        Group $customGroupSource,
        array $data = []
    ) {

        parent::__construct($context, $registry, $formFactory, $data);
        $this->_systemStore = $systemStore;
        $this->_wysiwyg = $wysiwyg;
        $this->thankYouPage = $thankYouPage;
        $this->preConfirmPage = $preConfirmPage;
        $this->customGroupSource = $customGroupSource;
    }

    /**
     * Prepare title for tab
     *
     * @return string
     */
    public function getTabTitle()
    {
        return $this->getTabLabel();
    }

    /**
     * Prepare label for tab
     *
     * @return string
     */
    public function getTabLabel()
    {
        return __('Landing Page');
    }

    /**
     * Can show tab in tabs
     *
     * @return boolean
     */
    public function canShowTab()
    {
        return true;
    }

    /**
     * Tab is hidden
     *
     * @return boolean
     */
    public function isHidden()
    {
        return false;
    }

    /**
     * Init form
     *
     * @return void
     */
    protected function _construct()
    {
        parent::_construct();
        $this->setId('newsletter_landingpage_form');
        $this->setTitle(__('Landing Page Information'));
    }

    /**
     * @return Generic
     * @throws LocalizedException
     */
    protected function _prepareForm()
    {
        $model = $this->_coreRegistry->registry('newsletter_landingpage');
        $form = $this->_formFactory->create();

        $form->setHtmlIdPrefix('newsletter_landingpage_');

        // ## General Information ##
        $fieldset = $form->addFieldset(
            'base_fieldset',
            [
                'legend' => __('General Information'),
                'class'  => 'fieldset-wide'
            ]
        );

        $fieldset->addType('image', Image::class);

        if ($model->getLandingId()) {
            $fieldset->addField('landing_id', 'hidden', ['name' => 'landing_id']);
        }

        $fieldset->addField(
            'title',
            'text',
            [
                'name' => 'title',
                'label' => __('Title'),
                'title' => __('Title'),
                'required' => true
            ]
        );

        $fieldset->addField(
            'url_key',
            'text',
            [
                'name' => 'url_key',
                'label' => __('Url Key'),
                'title' => __('Url Key'),
                'required' => true
            ]
        );

        $fieldset->addField(
            'enabled',
            'select',
            [
                'label' => __('Status'),
                'title' => __('Status'),
                'name' => 'enabled',
                'required' => true,
                'options' => ['1' => __('Enabled'), '0' => __('Disabled')]
            ]
        );

        if (!$model->getId()) {
            $model->setData('enabled', '1');
        }

        if (!$this->_storeManager->isSingleStoreMode()) {
            $field = $fieldset->addField(
                'store_ids',
                'multiselect',
                [
                    'name' => 'store_ids[]',
                    'label' => __('Assign to Store Views'),
                    'title' => __('Assign to Store Views'),
                    'required' => true,
                    'values' => $this->_systemStore->getStoreValuesForForm(false, true)
                ]
            );
            $renderer = $this->getLayout()->createBlock(
                Element::class
            );
            $field->setRenderer($renderer);
        }

        $typeField = $fieldset->addField(
            'form_type',
            'select',
            [
                'label' => __('Form Type'),
                'title' => __('Form Type'),
                'name' => 'form_type',
                'required' => true,
                'options' => [
                    '0' => __('NEWSLETTER'),
                    '1' => __('REGISTER'),
                    '2' => __('NEWSLETTER EDIT')
                ]
            ]
        );

        $assignToCustomerGroupField = $fieldset->addField(
            'assign_customer_group',
            'select',
            [
                'label' => __('Assign to customer group'),
                'title' => __('Assign to customer group'),
                'name' => 'assign_customer_group',
                'required' => true,
                'options' => ['1' => __('Yes'), '0' => __('No')]
            ]
        );

        $customerGroupField = $fieldset->addField(
            'customer_group',
            'select',
            [
                'label' => __('Assign Customer Group'),
                'title' => __('Assign Customer Group'),
                'name' => 'customer_group',
                'required' => false,
                'values' => $this->customGroupSource->toOptionArray()
            ]
        );

        $fieldset->addField(
            'image',
            'image',
            [
                'name' => 'image',
                'label' => __('Image'),
                'title' => __('Image')
            ]
        );

        $fieldset->addField(
            'description',
            'editor',
            [
                'name' => 'description',
                'label' => __('Description'),
                'title' => __('Description'),
                'config' => $this->_wysiwyg->getConfig(),
                'wysiwyg' => true
            ]
        );

        $fieldset->addField(
            'preconfirm_id',
            'select',
            [
                'name' => 'preconfirm_id',
                'label' => __('Pre Confirm Page Id'),
                'title' => __('Pre Confirm Page Id'),
                'required' => true,
                'options' => $this->preConfirmPage->getPreConfirmPageListArray()
            ]
        );

        $fieldset->addField(
            'thankyou_id',
            'select',
            [
                'label' => __('Thank You Page Id'),
                'title' => __('Thank You Page Id'),
                'name' => 'thankyou_id',
                'required' => true,
                'options' => $this->thankYouPage->getThankYouPageListArray()
            ]
        );

        $fieldset->addField(
            'code',
            'text',
            [
                'name' => 'code',
                'label' => __('Code'),
                'title' => __('Code'),
                'required' => true
            ]
        );

        $fieldset->addField(
            'custom_js',
            'textarea',
            [
                'name' => 'custom_js',
                'label' => __('Custom Js'),
                'title' => __('Custom Js'),
                'required' => false
            ]
        );

        $form->setValues($model->getData());
        $this->setForm($form);

        /** @var Dependence $dependenceBlock */
        $dependenceBlock = $this->getLayout()->createBlock(Dependence::class);
        $this->setChild(
            'form_after',
            $dependenceBlock
                ->addFieldMap($assignToCustomerGroupField->getHtmlId(), $assignToCustomerGroupField->getName())
                ->addFieldMap($typeField->getHtmlId(), $typeField->getName())
                ->addFieldMap($customerGroupField->getHtmlId(), $customerGroupField->getName())
                ->addFieldDependence($assignToCustomerGroupField->getName(), $typeField->getName(), 1)
                ->addFieldDependence($customerGroupField->getName(), $assignToCustomerGroupField->getName(), 1)
                ->addFieldDependence($customerGroupField->getName(), $typeField->getName(), 1)
        );

        return parent::_prepareForm();
    }
}
