<?php

namespace FiloBlu\Newsletter\Block\Adminhtml\LandingPage;

use Magento\Backend\Block\Widget\Context;
use Magento\Backend\Block\Widget\Form\Container;
use Magento\Framework\Phrase;
use Magento\Framework\Registry;

/**
 * Class Edit
 * @package FiloBlu\Newsletter\Block\Adminhtml\LandingPage
 */
class Edit extends Container
{
    /**
     * Core registry
     *
     * @var Registry
     */
    protected $_coreRegistry;

    /**
     * @param Context $context
     * @param Registry $registry
     * @param array $data
     */
    public function __construct(
        Context $context,
        Registry $registry,
        array $data = []
    )
    {
        $this->_coreRegistry = $registry;
        parent::__construct($context, $data);
    }

    /**
     * Retrieve text for header element depending on loaded store
     *
     * @return Phrase
     */
    public function getHeaderText()
    {
        if ($this->_coreRegistry->registry('newsletter_landingpage')->getId()) {
            return __("Edit Landing Page '%1'", $this->escapeHtml($this->_coreRegistry->registry('newsletter_landingpage')->getTitle()));
        }

        return __('New Landing Page');
    }

    /**
     * Initialize store edit block
     *
     * @return void
     */
    protected function _construct()
    {
        $this->_objectId = 'landing_id';
        $this->_blockGroup = 'FiloBlu_Newsletter';
        $this->_controller = 'adminhtml_landingPage';

        parent::_construct();

        if ($this->_isAllowedAction('FiloBlu_Newsletter::landing_listsave')) {
            $this->buttonList->update('save', 'label', __('Save Landing Page'));
            $this->buttonList->add(
                'saveandcontinue',
                [
                    'label' => __('Save and Continue Edit'),
                    'class' => 'save',
                    'data_attribute' => [
                        'mage-init' => [
                            'button' => ['event' => 'saveAndContinueEdit', 'target' => '#edit_form'],
                        ],
                    ]
                ],
                -100
            );

        } else {
            $this->buttonList->remove('save');
        }

        if ($this->_isAllowedAction('FiloBlu_Newsletter::landing_listdelete')) {
            $this->buttonList->update('delete', 'label', __('Delete Landing Page'));
        } else {
            $this->buttonList->remove('delete');
        }
    }

    /**
     * Check permission for passed action
     *
     * @param string $resourceId
     * @return bool
     */
    protected function _isAllowedAction($resourceId)
    {
        return $this->_authorization->isAllowed($resourceId);
    }

    /**
     * Getter of url for "Save and Continue" button
     * tab_id will be replaced by desired by JS later
     *
     * @return string
     */
    protected function _getSaveAndContinueUrl()
    {
        return $this->getUrl('filoblulandingadmin/*/save', ['_current' => true, 'back' => 'edit', 'active_tab' => '']);
    }
}