<?php

declare(strict_types=1);

namespace FiloBlu\Newsletter\Block\Account\Create;

use FiloBlu\Newsletter\Block\Widget\Country;
use FiloBlu\Newsletter\Helper\Data;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\View\Element\Block\ArgumentInterface;
use Magento\Framework\View\Element\Template;
use Magento\Framework\View\Element\Template\Context;

/**
 * Class AdditionalFields
 * @package FiloBlu\Newsletter\Block\Account\Create
 */
class AdditionalFields implements ArgumentInterface
{

    /**
     * Helper
     *
     * @var Data
     */
    public $helper;

    /**
     * @var Country
     */
    public $directoryBlock;

    /**
     * AdditionalFields constructor.
     * @param Data $helper
     * @param Country $directoryBlock
     */
    public function __construct(
        Data $helper,
        Country $directoryBlock
    ) {
        $this->helper = $helper;
        $this->directoryBlock = $directoryBlock;
    }

    /**
     * @return string
     * @throws LocalizedException
     * @throws NoSuchEntityException
     */
    public function getCountries()
    {
        return $this->directoryBlock->getCountryHtmlSelect();
    }

    /**
     * @return \FiloBlu\Newsletter\Helper\Data
     */
    public function getHelper(): Data
    {
        return $this->helper;
    }

}
