<?php

namespace FiloBlu\Label\Setup;

use Magento\Framework\Setup\UpgradeSchemaInterface;
use Magento\Framework\Setup\SchemaSetupInterface;
use Magento\Framework\Setup\ModuleContextInterface;

class UpgradeSchema implements UpgradeSchemaInterface
{
    /**
     * @param SchemaSetupInterface $setup
     * @param ModuleContextInterface $context
     * @return void
     */
    public function upgrade(SchemaSetupInterface $setup, ModuleContextInterface $context)
    {
        $installer = $setup;

        $installer->startSetup();

        if (version_compare($context->getVersion(), '1.0.10', '<')) {
            if ($setup->getConnection()->tableColumnExists('translation', 'string')) {
                $setup->run("ALTER TABLE `translation` MODIFY COLUMN `string` VARCHAR(512);");
            }

            if ($setup->getConnection()->tableColumnExists('translation', 'translate')) {
                $setup->run("ALTER TABLE `translation` MODIFY COLUMN `translate` VARCHAR(512);");
            }
        }
        $installer->endSetup();
    }
}