<?php
namespace FiloBlu\Label\Setup;

use Magento\Framework\DB\Ddl\Table;
use Magento\Framework\Setup\InstallSchemaInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\SchemaSetupInterface;

/**
 * @codeCoverageIgnore
 */
class InstallSchema implements InstallSchemaInterface
{
    /**
     * {@inheritdoc}
     */
    public function install(SchemaSetupInterface $setup, ModuleContextInterface $context)
    {

        $installer = $setup;

        $installer->startSetup();

        /**
         * Create table 'label_coretranslate'
         */
        $table = $installer->getConnection()->newTable(
            $installer->getTable('label_coretranslate')
        )
            ->addColumn(
                'id',
                Table::TYPE_INTEGER,
                null,
                ['identity' => true, 'unsigned' => true, 'nullable' => false, 'primary' => true],
                'label_coretranslate'
            )
            ->addColumn(
                'key_id',
                Table::TYPE_INTEGER,
                null,
                ['nullable' => false],
                '	key_id'
            )
            ->addColumn(
                'string',
                Table::TYPE_TEXT,
                '64k',
                [],
                'string'
            )
            ->addColumn(
                'store_id',
                Table::TYPE_INTEGER,
                null,
                ['nullable' => false],
                'store_id'
            )
            ->addColumn(
                'translate',
                Table::TYPE_TEXT,
                '64k',
                [],
                'translate'
            )
            ->addColumn(
                'locale',
                Table::TYPE_TEXT,
                '64k',
                [],
                'locale'
            )
            ->addColumn(
                'crc_string',
                Table::TYPE_TEXT,
                '64k',
                [],
                'crc_string'
            )
            /*{{CedAddTableColumn}}}*/


            ->setComment(
                'FiloBlu Label label_coretranslate'
            );

        $installer->getConnection()->createTable($table);
        /*{{CedAddTable}}*/

        $installer->endSetup();

    }
}
