<?php

namespace FiloBlu\Label\Model\Grid;
/**
 * Class Stores
 * @package FiloBlu\Label\Model\Grid
 */
class Stores implements \Magento\Framework\Data\OptionSourceInterface
{
    /** @var \Magento\Store\Model\StoreManagerInterface */
    private $storeManager;

    /** @var array|null */
    private $storeArray;

    /** @var array|null */
    private $storeOptions;

    /**
     * Stores constructor.
     * @param \Magento\Store\Model\StoreManagerInterface $storeManager
     */
    public function __construct(\Magento\Store\Model\StoreManagerInterface $storeManager)
    {
        $this->storeManager = $storeManager;
    }

    /**
     * Get options
     *
     * @return array
     */
    public function toOptionArray()
    {
        if(!$this->storeOptions)
        {
            $this->storeOptions[] = ['label' => '', 'value' => ''];
            foreach ($this->getOptionArray() as $key => $value) {
                $this->storeOptions[] = [
                    'label' => $value,
                    'value' => $key,
                ];
            }
        }

        return $this->storeOptions;
    }

    /**
     * @return array
     */
    public function getOptionArray()
    {
        if(!$this->storeArray) {

            $this->storeArray = [];

            foreach ($this->storeManager->getStores(true) as $store) {

                if ((int)$store->getId() === 0) {
                    $this->storeArray[$store->getId()] = 'Default';
                    continue;
                }

                $this->storeArray[$store->getId()] = $store->getCode();
            }
        }

        return  $this->storeArray;
    }
}
