<?php

namespace FiloBlu\Label\Model\Grid;

use Magento\Store\Api\StoreConfigManagerInterface;

/**
 * Class Locales
 * @package FiloBlu\Label\Model\Grid
 */
class Locales implements \Magento\Framework\Data\OptionSourceInterface
{
    /** @var StoreConfigManagerInterface */
    private $storeConfigManager;

    /** @var array|null */
    private $localeArray;

    /** @var array|null */
    private $localeOptions;

    /**
     * Stores constructor.
     * @param \Magento\Store\Model\StoreManagerInterface $storeConfigManager
     */
    public function __construct(StoreConfigManagerInterface $storeConfigManager)
    {
        $this->storeConfigManager = $storeConfigManager;
    }

    /**
     * Get options
     *
     * @return array
     */
    public function toOptionArray()
    {
        if(!$this->localeOptions) {
            $this->localeOptions = [];
            foreach ($this->getOptionArray() as $key => $value) {
                $this->localeOptions[] = [
                    'label' => $value,
                    'value' => $key,
                ];
            }
        }

        return $this->localeOptions;
    }

    /**
     * @return array
     */
    public function getOptionArray()
    {
        if(!$this->localeArray)
        {
            $this->localeArray = [];

            foreach ($this->storeConfigManager->getStoreConfigs() as $storeConfig) {
                $this->localeArray[$storeConfig->getLocale()] = $storeConfig->getLocale();
            }
        }

        return $this->localeArray;
    }
}
