<?php

namespace FiloBlu\Label\Block\Adminhtml\Coretranslate\Edit\Tab;

/**
 * Class General
 * @package FiloBlu\Label\Block\Adminhtml\Coretranslate\Edit\Tab
 */
class General extends \Magento\Backend\Block\Widget\Form\Generic implements \Magento\Backend\Block\Widget\Tab\TabInterface
{
    /**
     * @var \Magento\Store\Model\System\Store
     */
    protected $_systemStore;
    /**
     * @var \FiloBlu\Label\Model\Grid\Stores
     */
    private $storeOptions;
    /**
     * @var \FiloBlu\Label\Model\Grid\Locales
     */
    private $localeOptions;

    /**
     * General constructor.
     * @param \Magento\Backend\Block\Template\Context $context
     * @param \Magento\Framework\Registry $registry
     * @param \Magento\Framework\Data\FormFactory $formFactory
     * @param \Magento\Store\Model\System\Store $systemStore
     * @param \FiloBlu\Label\Model\Grid\Stores $storeOptions
     * @param \FiloBlu\Label\Model\Grid\Locales $localeOptions
     * @param array $data
     */
    public function __construct(
        \Magento\Backend\Block\Template\Context $context,
        \Magento\Framework\Registry $registry,
        \Magento\Framework\Data\FormFactory $formFactory,
        \Magento\Store\Model\System\Store $systemStore,
        \FiloBlu\Label\Model\Grid\Stores $storeOptions,
        \FiloBlu\Label\Model\Grid\Locales $localeOptions,
        array $data = []
    )
    {
        parent::__construct($context, $registry, $formFactory, $data);
        $this->_systemStore = $systemStore;
        $this->storeOptions = $storeOptions;
        $this->localeOptions = $localeOptions;
    }

    /**
     * Prepare label for tab
     *
     * @return string
     */
    public function getTabLabel()
    {
        return __('General');
    }

    /**
     * Prepare title for tab
     *
     * @return string
     */
    public function getTabTitle()
    {
        return __('General');
    }

    /**
     * {@inheritdoc}
     */
    public function canShowTab()
    {
        return true;
    }

    /**
     * {@inheritdoc}
     */
    public function isHidden()
    {
        return false;
    }

    /**
     * Prepare form
     *
     * @return $this
     */
    protected function _prepareForm()
    {
        /* @var $model \Magento\Cms\Model\Page */
        $model = $this->_coreRegistry->registry('label_coretranslate');
        $isElementDisabled = false;
        /** @var \Magento\Framework\Data\Form $form */
        $form = $this->_formFactory->create();

        $form->setHtmlIdPrefix('page_');

        $fieldset = $form->addFieldset('base_fieldset', ['legend' => __('General')]);

        if ($model->getId()) {
            $fieldset->addField('key_id', 'hidden', ['name' => 'filoblu_labelmanager[key_id]']);
        }

        $fieldset->addField(
            'store_id',
            'select',
            [
                'name'     => 'filoblu_labelmanager[store_id]',
                'label'    => __('Store'),
                'title'    => __('Store'),
                'options'  => $this->storeOptions->getOptionArray(),
                'required' => true
            ]
        );
        $fieldset->addField(
            'string',
            'text',
            [
                'name'     => 'filoblu_labelmanager[string]',
                'label'    => __('String'),
                'title'    => __('String'),
                'required' => true
            ]
        );
        $fieldset->addField(
            'translate',
            'text',
            [
                'name'     => 'filoblu_labelmanager[translate]',
                'label'    => __('Translate'),
                'title'    => __('Translate'),
                'required' => true
            ]
        );
        $fieldset->addField(
            'locale',
            'select',
            [
                'name'     => 'filoblu_labelmanager[locale]',
                'label'    => __('Locale'),
                'title'    => __('Locale'),
                'options'  => $this->localeOptions->getOptionArray(),
                'required' => true
            ]
        );
        /*{{CedAddFormField}}*/

        if (!$model->getId()) {
            $model->setData('status', $isElementDisabled ? '2' : '1');
        }

        $form->setValues($model->getData());
        $this->setForm($form);

        return parent::_prepareForm();
    }

    /**
     * Check permission for passed action
     *
     * @param string $resourceId
     * @return bool
     */
    protected function _isAllowedAction($resourceId)
    {
        return $this->_authorization->isAllowed($resourceId);
    }
}
