<?php

namespace FiloBlu\GtidUrlRewrite\Observer;


use Magento\Framework\Event\ObserverInterface;
use Magento\Framework\Event\Observer;
use Magento\Catalog\Model\Category;
use Magento\CatalogUrlRewrite\Model\CategoryUrlRewriteGenerator;
use Magento\CatalogUrlRewrite\Model\UrlRewriteBunchReplacer;
use Magento\Store\Model\StoreManagerInterface;
use Magento\UrlRewrite\Model\UrlPersistInterface;
use Psr\Log\LoggerInterface;

class GenerateCategoryUrlRewrite implements ObserverInterface
{
    protected $categoryUrlRewriteGenerator;
    protected $urlPersist;
    protected $storeManager;
    protected $logger;

    public function __construct(
        CategoryUrlRewriteGenerator $categoryUrlRewriteGenerator,
        UrlPersistInterface $urlPersist,
        StoreManagerInterface $storeManager,
        LoggerInterface $logger
    ) {
        $this->categoryUrlRewriteGenerator = $categoryUrlRewriteGenerator;
        $this->urlPersist = $urlPersist;
        $this->storeManager = $storeManager;
        $this->logger = $logger;
    }

    public function execute(Observer $observer)
    {
        /** @var Category $category */
        $category = $observer->getEvent()->getCategory();

        if (!$category || $category->getParentId() == Category::TREE_ROOT_ID) {
            return;
        }

        try {
            $storeIds = [];

            if ((int)$category->getStoreId() === 0) {
                foreach ($this->storeManager->getStores() as $store) {
                    $storeIds[] = (int)$store->getId();
                }
            } else {
                $storeIds[] = (int)$category->getStoreId();
            }

            foreach ($storeIds as $storeId) {
                $categoryClone = clone $category;
                $categoryClone->setStoreId($storeId);

                $rewrites = $this->categoryUrlRewriteGenerator->generate($categoryClone);

                if (!empty($rewrites)) {
                    $this->urlPersist->replace($rewrites);
                    $this->logger->info("Category rewrites generated for store ID {$storeId}, category ID {$category->getId()}");
                } else {
                    $this->logger->warning("No URL rewrites generated for category ID {$category->getId()} in store {$storeId}");
                }
            }

        } catch (\Exception $e) {
            $this->logger->error('Category URL rewrite generation error: ' . $e->getMessage());
        }
    }
}
