<?php

namespace FiloBlu\GtidUrlRewrite\Model\UrlRewrite\Map;

use Magento\Framework\App\ResourceConnection;
use Magento\CatalogUrlRewrite\Model\Map\HashMapPool;
use Magento\CatalogUrlRewrite\Model\Map\DataCategoryUsedInProductsHashMap;
use Magento\CatalogUrlRewrite\Model\Map\DataCategoryHashMap;
use Magento\UrlRewrite\Model\MergeDataProvider;

class DataCategoryUrlRewriteDatabaseMap implements \Magento\CatalogUrlRewrite\Model\Map\DatabaseMapInterface
{
    const ENTITY_TYPE = 'category';

    private $connection;
    private $hashMapPool;

    public function __construct(
        ResourceConnection $resourceConnection,
        HashMapPool $hashMapPool
    ) {
        $this->connection = $resourceConnection;
        $this->hashMapPool = $hashMapPool;
    }

    public function getData($categoryId, $key)
    {
        $conn = $this->connection->getConnection();
        $table = $this->connection->getTableName('url_rewrite');

        $entityIds = array_merge(
            $this->hashMapPool->getDataMap(DataCategoryUsedInProductsHashMap::class, $categoryId)->getAllData($categoryId),
            $this->hashMapPool->getDataMap(DataCategoryHashMap::class, $categoryId)->getAllData($categoryId)
        );

        if (empty($entityIds)) {
            return [];
        }

        $select = $conn->select()
            ->from(['e' => $table], ['e.*',
                'hash_key' => new \Zend_Db_Expr(
                    "CONCAT(e.store_id,'" . MergeDataProvider::SEPARATOR . "', e.entity_id)"
                )
            ])
            ->where('e.entity_type = ?', self::ENTITY_TYPE)
            ->where('e.entity_id IN (?)', $entityIds);

        if ($key !== '') {
            $select->where("CONCAT(e.store_id,'" . MergeDataProvider::SEPARATOR . "', e.entity_id) = ?", $key);
        }

        return $conn->fetchAll($select);
    }

    public function destroyTableAdapter($categoryId)
    {
        // TODO: Implement destroyTableAdapter() method.
    }
}
