<?php

namespace FiloBlu\GtidUrlRewrite\Plugin;

use FiloBlu\GtidUrlRewrite\Helper\Data;
use FiloBlu\GtidUrlRewrite\Model\CategoryRewrite;
use Magento\Catalog\Model\Category;
use Magento\CatalogUrlRewrite\Observer\CategoryProcessUrlRewriteSavingObserver;
use Magento\Framework\Event\Observer;

class CategoryProcessUrlRewrite
{
    /**
     * @var CategoryRewrite
     */
    private $categoryRewrite;
    /**
     * @var Data
     */
    private $helper;

    /**
     * @param CategoryRewrite $categoryRewrite
     * @param Data $helper
     */
    public function __construct(
        CategoryRewrite $categoryRewrite,
        Data $helper
    )
    {
        $this->categoryRewrite = $categoryRewrite;
        $this->helper = $helper;
    }

    /**
     * @param CategoryProcessUrlRewriteSavingObserver $subject
     * @param Observer $observer
     * @return null
     */
    public function beforeExecute(CategoryProcessUrlRewriteSavingObserver $subject, Observer $observer)
    {
        /** @var Category $category */
        $category = $observer->getEvent()->getData('category');

        $this->categoryRewrite->setCurrentCategory($category);

        return null;
    }
}
