This module try to avoid GTID consistency violations under Gcloud Mysql 5.*

The main issue occurs when 
- binlog is enabled
- creation / deletion of TRIGGER occurs
- creation / deletion of TEMPORARY TABLE

```log
[2024-07-30 09:54:06] report.CRITICAL: SQLSTATE[HY000]: General error: 1787 Statement violates GTID consistency: CREATE TEMPORARY TABLE and DROP TEMPORARY TABLE can only be executed outside transactional context.  These statements are also not allowed in a function or trigger because functions and triggers are also considered to be multi-statement transactions., query was: CREATE TEMPORARY TABLE `tmp_select_JEnPY8TO7GkxzJI2g0KR6fx0KCUsjITt` (PRIMARY KEY(`url_rewrite_id`),INDEX `HASHKEY_ENTITY_STORE` USING HASH(`hash_key`),INDEX `ENTITY_STORE` USING HASH(`entity_id`,`store_id`)) ENGINE=`INNODB` IGNORE (SELECT `e`.*, CONCAT(e.store_id,'_', e.entity_id) AS `hash_key` FROM `url_rewrite` AS `e` WHERE (entity_type = 'category') AND (entity_id IN('2057'))) {"exception":"[object] (Zend_Db_Statement_Exception(code: 0): SQLSTATE[HY000]: General error: 1787 Statement violates GTID consistency: CREATE TEMPORARY TABLE and DROP TEMPORARY TABLE can only be executed outside transactional context.  These statements are also not allowed in a function or trigger because functions and triggers are also considered to be multi-statement transactions., query was: CREATE TEMPORARY TABLE `tmp_select_JEnPY8TO7GkxzJI2g0KR6fx0KCUsjITt` (PRIMARY KEY(`url_rewrite_id`),INDEX `HASHKEY_ENTITY_STORE` USING HASH(`hash_key`),INDEX `ENTITY_STORE` USING HASH(`entity_id`,`store_id`)) ENGINE=`INNODB` IGNORE (SELECT `e`.*, CONCAT(e.store_id,'_', e.entity_id) AS `hash_key` FROM `url_rewrite` AS `e` WHERE (entity_type = 'category') AND (entity_id IN('2057'))) at /var/www/html/vendor/magento/framework/DB/Statement/Pdo/Mysql.php:110, PDOException(code: HY000): SQLSTATE[HY000]: General error: 1787 Statement violates GTID consistency: CREATE TEMPORARY TABLE and DROP TEMPORARY TABLE can only be executed outside transactional context.  These statements are also not allowed in a function or trigger because functions and triggers are also considered to be multi-statement transactions. at /var/www/html/vendor/magento/framework/DB/Statement/Pdo/Mysql.php:91)"} []
```

# Possible Fixes

## You can try to disable binlog logging
gcloud sql instances patch [INSTANCE_NAME] --no-enable-bin-log

## You can try to install this module


