<?php
/**
 * Copyright © 2015 FiloBlu. All rights reserved.
 */

namespace FiloBlu\Flow\Model;

use Magento\Framework\Data\Collection\AbstractDb;
use Magento\Framework\Model\AbstractModel;
use Magento\Framework\Model\Context;
use Magento\Framework\Model\ResourceModel\AbstractResource;
use Magento\Framework\Registry;

/**
 * Class VideosFlow
 * @method string getVideoName()
 * @method string getVideoSku()
 * @method string getVideoPosition()
 * @method string getVideoPath()
 * @method string getVideoType()
 * @method string getVideoHide()
 * @method string getVideoStatus()
 * @method string getVideoAlt()
 * @method string getVideoProcessTime()
 * @method string getMetaProcessed()
 * @method int getMetaFile()
 * @method self setVideoName(string $name)
 * @method self setVideoSku(string $sku)
 * @method self setVideoPosition(string $position)
 * @method self setVideoPath(string $path)
 * @method self setVideoType(string $type)
 * @method self setVideoHide(int $hide)
 * @method self setVideoStatus(string $status)
 * @method self setVideoAlt(string $alt)
 * @method self setMetaFile(int $metafile)
 * @method self setVideoProcessTime(string $time)
 * @method self setMetaProcessed(string $processed)
 * @package FiloBlu\Flow\Model
 */
class Videosflow extends AbstractModel
{
    /**
     * @var string
     */
    const STATUS_FOUND = 'found';

    /**
     * @var string
     */
    const STATUS_RECEIVED = 'received';

    /**
     * @var string
     */
    const STATUS_PARSED = 'parsed';

    /**
     * @var string
     */
    const STATUS_PROCESSED = 'processed';

    /**
     * @var string
     */
    const STATUS_ERROR = 'error';

    /**
     * @var string
     */
    const PRIORITY_HIGH = 'high';

    /**
     * @var string
     */
    const PRIORITY_LOW = 'low';

    /**
     * @var string
     */
    const PRIORITY_NORMAL = 'normal';

    /**
     * Videosflow constructor.
     * @param Context $context
     * @param Registry $registry
     * @param AbstractResource|null $resource
     * @param AbstractDb|null $resourceCollection
     * @param array $data
     */
    public function __construct(
        Context $context,
        Registry $registry,
        AbstractResource $resource = null,
        AbstractDb $resourceCollection = null,
        array $data = []
    ) {
        parent::__construct($context, $registry, $resource, $resourceCollection, $data);
    }

    /**
     * @return void
     */
    public function _construct()
    {
        $this->_init(ResourceModel\Videosflow::class);
    }
}
