<?php

namespace FiloBlu\Flow\Model;

use FiloBlu\Flow\Api\SwatchColorInterface;
use FiloBlu\Flow\Api\SwatchColorRepositoryInterface;
use Magento\Framework\App\ResourceConnectionFactory;
use Magento\Framework\DB\Adapter\AdapterInterface;
use Zend_Db_Expr;

/**
 * Class SwatchRepository
 * @package FiloBlu\Flow\Model
 */
class SwatchColorRepository implements SwatchColorRepositoryInterface
{

    /** @var AdapterInterface */
    protected $connection;

    /**
     * @var ResourceConnectionFactory
     */
    protected $connectionFactory;

    /**
     * LogRepository constructor.
     * @param ResourceConnectionFactory $connectionFactory
     */
    public function __construct(
        ResourceConnectionFactory $connectionFactory
    ) {
        $this->connectionFactory = $connectionFactory;
    }


    public function save(SwatchColorInterface $swatchColor)
    {
        $connection = $this->getConnection();
        $table = $connection->getTableName('flow_swatch_color');
        $connection->insert(
            $table,
            [
                'attribute' => $swatchColor->getAttribute(),
                'admin_name' => $swatchColor->getAdminName(),
                'value' => $swatchColor->getValue(),
                'option_id' => $swatchColor->getOptionId(),
                'type' => $swatchColor->getType(),
                'meta_file' => $swatchColor->getMetaFile(),
                'meta_insert_time' => $swatchColor->getMetaInsertTime(),
                'meta_processed' => $swatchColor->getMetaProcessed()
            ]
        );
    }

    /**
     * @return AdapterInterface
     */
    protected function getConnection()
    {
        if ($this->connection === null) {
            $this->connection = $this->connectionFactory->create()->getConnection();
        }

        return $this->connection;
    }
}
