<?php

namespace FiloBlu\Flow\Model;

use FiloBlu\Flow\Api\SwatchColorInterface;
use Magento\Framework\Model\AbstractModel;

/**
 * Class SwatchImage
 * @package FiloBlu\Flow\Model
 */
class SwatchColor extends AbstractModel implements SwatchColorInterface
{
    public function _construct()
    {
        $this->_init(ResourceModel\SwatchColor::class);
    }

    public function getId()
    {
        return $this->getData('id');
    }

    public function setId($id)
    {
        $this->setData('id', $id);
        return $this;
    }

    public function getAttribute()
    {
        return $this->getData('attribute');
    }

    public function setAttribute($attribute)
    {
        $this->setData('attribute', $attribute);
        return $this;
    }

    public function getOptionName()
    {
        return $this->getData('option_name');
    }

    public function setOptionName($adminName)
    {
        $this->setData('option_name', $adminName);
        return $this;
    }

    public function getOptionId()
    {
        return $this->getData('option_id');
    }

    public function setOptionId($option_id)
    {
        $this->setData('option_id', $option_id);
        return $this;
    }

    public function getType()
    {
        return $this->getData('type');
    }

    public function setType($type)
    {
        $this->setData('type', $type);
        return $this;
    }

    public function getValue()
    {
        return $this->getData('value');
    }

    public function setValue($value)
    {
        $this->setData('value', $value);
        return $this;
    }

    public function getMetaFile()
    {
        return $this->getData('meta_file');
    }

    public function setMetaFile($file)
    {
        $this->setData('meta_file', $file);
        return $this;
    }

    public function getMetaInsertTime()
    {
        return $this->getData('meta_insert_time');
    }

    public function setMetaInsertTime($time)
    {
        $this->setData('meta_insert_time', $time);
        return $this;
    }

    public function getMetaProcessed()
    {
        return $this->getData('meta_processed');
    }

    public function setMetaProcessed($meta_processed)
    {
        $this->setData('meta_processed', $meta_processed);
        return $this;
    }
}
