<?php

namespace FiloBlu\Flow\Model;

use Exception;
use FiloBlu\Flow\Api\SwatchInterface;
use Magento\Framework\Model\AbstractModel;

/**
 * Class Swatch
 * @package FiloBlu\Flow\Model
 */
class Swatch extends AbstractModel implements SwatchInterface
{
    /**
     * @return void
     */
    public function _construct()
    {
        $this->_init(ResourceModel\Swatch::class);
    }

    /**
     * @return int|mixed
     */
    public function getId() {
        return $this->getData('id');
    }

    /**
     * @param mixed $id
     * @return AbstractModel|mixed
     */
    public function setId($id) {
        $this->setData('id',$id);
        return $this->getData();
    }

    /**
     * @return mixed
     */
    public function getName() {
        return $this->getData('name');
    }

    /**
     * @param $name
     * @return mixed
     */
    public function setName($name) {
        $this->setData('name',$name);
        return $this->getData();
    }

    /**
     * @return mixed
     */
    public function getAttribute() {
        return $this->getData('attribute');
    }

    /**
     * @param $attribute
     * @return mixed
     */
    public function setAttribute($attribute){
        $this->setData('attribute',$attribute);
        return $this->getData();
    }

    /**
     * @return mixed
     */
    public function getOptionName() {
        return $this->getData('option_name');
    }

    /**
     * @param $optionName
     * @return mixed
     */
    public function setOptionName($optionName){
        $this->setData('option_name',$optionName);
        return $this->getData();
    }

    /**
     * @return mixed
     */
    public function getOptionId(){
        return $this->getData('option_id');
    }

    /**
     * @param $optionId
     * @return mixed
     */
    public function setOptionId($optionId) {
        $this->setData('option_id',$optionId);
        return $this->getData();
    }

    /**
     * @return mixed
     */
    public function getType() {
        return $this->getData('type');
    }

    /**
     * @param $type
     * @return mixed
     */
    public function setType($type) {
        $this->setData('type',$type);
        return $this->getData();
    }

    /**
     * @return mixed
     */
    public function getPath(){
        return $this->getData('path');
    }

    /**
     * @param $path
     * @return mixed
     */
    public function setPath($path){
        $this->setData('path',$path);
        return $this->getData();
    }

    /**
     * @return mixed
     */
    public function getStatus() {
        return $this->getData('status');
    }

    /**
     * @param $status
     * @return mixed
     */
    public function setStatus($status) {
        $this->setData('status',$status);
        return $this->getData();
    }

    /**
     * @return mixed
     */
    public function getLog(){
        return $this->getData('log');
    }

    /**
     * @param $log
     * @return mixed
     */
    public function setLog($log) {
        $this->setData('log',$log);
        return $this->getData();
    }

    /**
     * @return mixed
     */
    public function getMetaFile()
    {
        return $this->getData('meta_file');
    }

    /**
     * @param $file
     * @return mixed
     */
    public function setMetaFile($file)
    {
        $this->setData('meta_file', $file);
        return $this->getData();
    }

    /**
     * @return mixed
     */
    public function getMetaInsertTime()
    {
        return $this->getData('meta_insert_time');
    }

    /**
     * @param $time
     * @return mixed
     */
    public function setMetaInsertTime($time)
    {
        $this->setData('meta_insert_time', $time);
    }

    /**
     * @return mixed
     */
    public function getMetaProcessed()
    {
        return $this->getData('meta_processed');
    }

    /**
     * @param $meta_processed
     * @return mixed
     */
    public function setMetaProcessed($meta_processed)
    {
        $this->setData('meta_processed', $meta_processed);
        return $this->getData();
    }

}
