<?php

namespace FiloBlu\Flow\Model;

use Exception;
use FiloBlu\Flow\Api\StockAdjustmentInterface;
use Magento\Framework\Model\AbstractModel;

/**
 * Class StockAdjustment
 * @package FiloBlu\Flow\Model
 */
class StockAdjustment extends AbstractModel implements StockAdjustmentInterface
{
    /**
     * @return void
     */
    public function _construct()
    {
        $this->_init(ResourceModel\StockAdjustment::class);
    }

    /**
     * @return int|mixed
     */
    public function getMetaId() {
        return $this->getData('meta_id');
    }

    /**
     * @param mixed $id
     * @return AbstractModel|mixed
     */
    public function setMetaId($id) {
        $this->setData('meta_id',$id);
        return $this->getData();
    }

    /**
     * @return mixed|void
     */
    public function getSku()
    {
        return $this->getData('sku');
    }

    /**
     * @param $sku
     * @return mixed|void
     */
    public function setSku($sku)
    {
        $this->setData('sku',$sku);
        return $this->getData();
    }

    /**
     * @return array|mixed|null
     */
    public function getWarehouse()
    {
        return $this->getData('warehouse');
    }

    /**
     * @param $warehouse
     * @return array|mixed|null
     */
    public function setWarehouse($warehouse)
    {
        $this->setData('warehouse',$warehouse);
        return $this->getData();
    }

    /**
     * @return array|mixed|null
     */
    public function getAdjustment()
    {
        return $this->getData('adjustment');
    }

    /**
     * @param $adjustment
     * @return array|mixed|null
     */
    public function setAdjustment($adjustment)
    {
        $this->setData('adjustment',$adjustment);
        return $this->getData();
    }

    /**
     * @return array|mixed|null
     */
    public function getFinalQuantity()
    {
        return $this->getData('final_quantity');
    }

    /**
     * @param $finalQuantity
     * @return array|mixed|null
     */
    public function setFinalQuantity($finalQuantity)
    {
        $this->setData('final_quantity',$finalQuantity);
        return $this->getData();
    }

    /**
     * @return mixed
     */
    public function getSource(){
        return $this->getData('source');
    }

    /**
     * @param $source
     * @return mixed
     */
    public function setSource($source){
        $this->setData('source',$source);
        return $this->getData();
    }

    /**
     * @return mixed
     */
    public function getDetail(){
        return $this->getData('detail');
    }

    /**
     * @param $detail
     * @return mixed
     */
    public function setDetail($detail){
        $this->setData('detail',$detail);
        return $this->getData();
    }

    /**
     * @return mixed
     */
    public function getMetaFile()
    {
        return $this->getData('meta_file');
    }

    /**
     * @param $file
     * @return mixed
     */
    public function setMetaFile($file)
    {
        $this->setData('meta_file', $file);
        return $this->getData();
    }

    /**
     * @return mixed
     */
    public function getMetaInsertTime()
    {
        return $this->getData('meta_insert_time');
    }

    /**
     * @param $time
     * @return mixed
     */
    public function setMetaInsertTime($time)
    {
        $this->setData('meta_insert_time', $time);
    }

    /**
     * @return mixed
     */
    public function getMetaProcessed()
    {
        return $this->getData('meta_processed');
    }

    /**
     * @param $meta_processed
     * @return mixed
     */
    public function setMetaProcessed($meta_processed)
    {
        $this->setData('meta_processed', $meta_processed);
        return $this->getData();
    }

    /**
     * @return array|mixed|null
     */
    public function getMetaRefId()
    {
        return $this->getData('meta_ref_id');
    }

    /**
     * @param $metaRefId
     * @return array|mixed|null
     */
    public function setMetaRefId($metaRefId)
    {
        $this->setData('meta_ref_id', $metaRefId);
        return $this->getData();
    }

    /**
     * @return array|mixed|null
     */
    public function getMetaProcessedTime()
    {
        return $this->getData('meta_processed_time');
    }

    /**
     * @param $metaProcessedTime
     * @return array|mixed|null
     */
    public function setMetaProcessedTime($metaProcessedTime)
    {
        $this->setData('meta_processed_time', $metaProcessedTime);
        return $this->getData();
    }
}
