<?php

namespace FiloBlu\Flow\Model\Parser\Filters;

use function in_array;

/**
 * Class Yesno
 * @package FiloBlu\Flow\Model\Parser\Filters
 */
class Yesno extends AbstractFilter
{
    /**
     * @var array allowed affermative values
     */
    const YES_VALUES = ['si', 'yes', 'y', 's'];

    /**
     * @param $value
     * @param $args
     * @return int|string
     */
    public function filter($value, $args)
    {
        if ($value === null || trim($value) === '') {
            return '';
        }

        if (in_array(strtolower(trim($value)), self::YES_VALUES, false)) {
            return 1;
        }

        return 0;
    }

}
