<?php

namespace FiloBlu\Flow\Model\Parser\Filters;

/**
 * Class SelectTranslationColor
 * @package FiloBlu\Flow\Model\Parser\Filters
 */
class SelectTranslationColor extends AbstractFilter
{
    /**
     * @param $value
     * @param $args
     * @return string
     */
    public function filter($value, $args)
    {
        if (trim($value) === '') {
            return '';
        }

        $default_attribute = (int)$args['default'];
        $default_value = $this->_row[2] . '_' . $this->_row[$default_attribute];

        if (trim($default_value) === '') {
            return '';
        }

        return str_replace("'", '', $default_value) . ';' . str_replace("'", '', $value);
    }
}