<?php

namespace FiloBlu\Flow\Model\Parser\Filters;

use function count;
use function is_array;

/**
 * Class Concat
 * @package FiloBlu\Flow\Model\Parser\Filters
 */
class Concat extends AbstractFilter
{

    /**
     * @param $value
     * @param $args
     * @return mixed|string
     */
    public function filter($value, $args)
    {
        $row_mapped = [];
        $rowToConcat = $args['rows'];
        $separator = $args['separator'];

        if (!is_array($rowToConcat) || empty($rowToConcat)) {
            return $value;
        }

        $row = $this->getRow();

        foreach ($rowToConcat as $CurrentRow) {
            if (isset($row[$CurrentRow]) && $row[$CurrentRow] !== '') {
                $row_mapped[] = $row[$CurrentRow];
            }
        }

        if (!count($row_mapped)) {
            return $value;
        }

        return implode($separator, $row_mapped);
    }
}
