<?php

namespace FiloBlu\Flow\Model\From;

use FiloBlu\Flow\Helper\SwatchColor as SwatchColorHelper;
use FiloBlu\Flow\Model\From\AbstractFrom;
use Magento\Framework\Data\Collection\AbstractDb;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Model\Context;
use Magento\Framework\Model\ResourceModel\AbstractResource;
use Magento\Framework\Registry;

class SwatchColor extends AbstractFrom
{

    /**
     * @var SwatchColorHelper
     */
    private $swatchColorHelper;

    /**
     * @param Context $context
     * @param Registry $registry
     * @param SwatchColorHelper $swatchColorHelper
     * @param AbstractResource|null $resource
     * @param AbstractDb|null $resourceCollection
     * @param array $data
     */
    public function __construct(
        Context           $context,
        Registry          $registry,
        SwatchColorHelper $swatchColorHelper,
        AbstractResource  $resource = null,
        AbstractDb        $resourceCollection = null,
        array             $data = []
    )
    {
        parent::__construct($context, $registry, $resource, $resourceCollection, $data);
        $this->swatchColorHelper = $swatchColorHelper;
    }

    /**
     * @return void
     * @noinspection MagicMethodsValidityInspection
     */
    public function _construct()
    {
        $this->_init(\FiloBlu\Flow\Model\ResourceModel\From\SwatchColor::class);
    }

    public function process()
    {
        $optionId = $this->getData('option_id');

        $value = $this->getData('value');

        try {
            $this->swatchColorHelper->insertOptionValue($optionId, $value);
        } catch (\Exception $e) {
            throw new LocalizedException(__($e->getMessage()));
        } catch (\Throwable $t) {
            throw new LocalizedException(__($t->getMessage()));
        }

        return $this;
    }

    public function sendErrorNotifications($file)
    {

    }


}
