<?php

namespace FiloBlu\Flow\Model\From\Entity;

use Exception;
use FiloBlu\Flow\Helper\LoggerProvider;
use Magento\Catalog\Model\ProductFactory;
use Magento\Eav\Model\Config;
use Magento\Eav\Model\ConfigFactory;
use Magento\Eav\Model\Entity\Attribute\Source\BooleanFactory;
use Magento\Eav\Model\Entity\AttributeFactory;
use Magento\Eav\Model\Entity\TypeFactory;
use Magento\Eav\Model\ResourceModel\Entity\Attribute\Option\CollectionFactory;
use Magento\Framework\ObjectManagerInterface;
use Magento\Framework\Registry;

/**
 * Class Attribute
 * @package FiloBlu\Flow\Model\From\Entity
 */
class Attribute extends AbstractEntity
{
    /**
     * @var ConfigFactory
     */
    protected $configFactory;

    /**
     * Attribute constructor.
     * @param Registry $registry
     * @param ProductFactory $productFactory
     * @param \FiloBlu\Flow\Helper\Product $helperProduct
     * @param \FiloBlu\Flow\Helper\Attribute $helperAttribute
     * @param LoggerProvider $loggerProvider
     * @param AttributeFactory $attributeFactory
     * @param CollectionFactory $attributeOptionCollectionFactory
     * @param ObjectManagerInterface $objectManager
     * @param ConfigFactory $configFactory
     * @param TypeFactory $entityTypeFactory
     * @param array $data
     */
    public function __construct(
        Registry $registry,
        ProductFactory $productFactory,
        \FiloBlu\Flow\Helper\Product $helperProduct,
        \FiloBlu\Flow\Helper\Attribute $helperAttribute,
        LoggerProvider $loggerProvider,
        AttributeFactory $attributeFactory,
        CollectionFactory $attributeOptionCollectionFactory,
        ObjectManagerInterface $objectManager,
        ConfigFactory $configFactory,
        TypeFactory $entityTypeFactory,
        BooleanFactory $booleanFactory,
        array $data = []
    ) {
        parent::__construct(
            $registry,
            $productFactory,
            $helperProduct,
            $helperAttribute,
            $loggerProvider,
            $attributeFactory,
            $attributeOptionCollectionFactory,
            $objectManager,
            $entityTypeFactory,
            $booleanFactory,
            $data

        );
        $this->configFactory = $configFactory;
    }

    /**
     * @return mixed|null
     * @throws Exception
     */
    protected function getObject()
    {
        if ($this->objectEntity === null) {
            /** @var Config $objectEntity */
            $objectEntity = $this->configFactory->create();
            $this->objectEntity = $objectEntity->getAttribute('catalog_product', $this->getObjectId());
        }
        if (!$this->getObjectId()) {
            throw new Exception('No id found for model ' . $this->getEntityModel() . ' with given identifier ' . $this->entityIdentifier);
        }
        if ($this->entityTypeCode !== 'product_attribute') {
            throw new Exception('We don\'t manage ' . $this->entityTypeCode . ' attributes yet');
        }

        $this->objectEntity->setStoreId($this->storeId);

        if (!$this->objectEntity->getId()) {
            throw new Exception('No instance found for model' . $this->getEntityModel() . ' with id ' . $this->getObjectId());
        }

        return $this->objectEntity;
    }

    /**
     * @return string|null
     */
    protected function getEntityModel()
    {
        if ($this->entityTypeModel === null) {
            $this->entityTypeModel = 'eav/entity_attribute';
        }

        return $this->entityTypeModel;
    }
}
