<?php

namespace FiloBlu\Flow\Model\Filters;

/**
 * Class SelectTranslation
 * @package FiloBlu\Flow\Model\Filters
 */
class SelectTranslation extends AbstractFilter
{
    /**
     * @param $value
     * @param $args
     * @return string
     */
    public function filter($value, $args)
    {
        if (trim($value) === '') {
            return '';
        }

        $default_attribute = $args['default'];
        if (!is_numeric($default_attribute)) {
            $default_attribute = $this->getColumnIndexByName($default_attribute);
        }
        $default_value = $this->_row[$default_attribute];
        return $default_value . ';' . $value;
    }
}
